/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.sched.api;

import com.fasterxml.jackson.core.type.TypeReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import software.xdev.sched.client.ApiClient;
import software.xdev.sched.client.ApiException;
import software.xdev.sched.client.Configuration;
import software.xdev.sched.client.Pair;
import software.xdev.sched.model.ExportSession;
import software.xdev.sched.model.Session;

public class SessionApi {
    private ApiClient apiClient;

    public SessionApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SessionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public String addSession(String sessionKey, String name, String sessionStart, String sessionEnd, String sessionType, String sessionSubtype, String description, URI mediaUrl, String venue, String address, String tags, String seats, URI rsvpUrl, String ticketMessage, String active, Object customFields) throws ApiException {
        return this.addSession(sessionKey, name, sessionStart, sessionEnd, sessionType, sessionSubtype, description, mediaUrl, venue, address, tags, seats, rsvpUrl, ticketMessage, active, customFields, Collections.emptyMap());
    }

    public String addSession(String sessionKey, String name, String sessionStart, String sessionEnd, String sessionType, String sessionSubtype, String description, URI mediaUrl, String venue, String address, String tags, String seats, URI rsvpUrl, String ticketMessage, String active, Object customFields, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (sessionKey == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionKey' when calling addSession");
        }
        if (name == null) {
            throw new ApiException(400, "Missing the required parameter 'name' when calling addSession");
        }
        if (sessionStart == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionStart' when calling addSession");
        }
        if (sessionEnd == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionEnd' when calling addSession");
        }
        if (sessionType == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionType' when calling addSession");
        }
        String localVarPath = "/api/session/add";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_key", sessionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_start", sessionStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_end", sessionEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_type", sessionType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_subtype", sessionSubtype));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("media_url", mediaUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("venue", venue));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("seats", seats));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rsvp_url", rsvpUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ticket_message", ticketMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("custom_fields", customFields));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String deleteSession(String sessionKey) throws ApiException {
        return this.deleteSession(sessionKey, Collections.emptyMap());
    }

    public String deleteSession(String sessionKey, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (sessionKey == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionKey' when calling deleteSession");
        }
        String localVarPath = "/api/session/del";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_key", sessionKey));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<ExportSession> exportSessions(Integer since, String format, String fields, Integer page, Integer limit, String stripHtml, String customData) throws ApiException {
        return this.exportSessions(since, format, fields, page, limit, stripHtml, customData, Collections.emptyMap());
    }

    public List<ExportSession> exportSessions(Integer since, String format, String fields, Integer page, Integer limit, String stripHtml, String customData, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/session/export";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("format", format));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("fields", fields));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("strip_html", stripHtml));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("custom_data", customData));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<List<ExportSession>> localVarReturnType = new TypeReference<List<ExportSession>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Session> listSessions(Integer since, String format, String status, String customData) throws ApiException {
        return this.listSessions(since, format, status, customData, Collections.emptyMap());
    }

    public List<Session> listSessions(Integer since, String format, String status, String customData, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/session/list";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("since", since));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("format", format));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("status", status));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("custom_data", customData));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json", "text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<List<Session>> localVarReturnType = new TypeReference<List<Session>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public String modifySession(String sessionKey, String name, String sessionStart, String sessionEnd, String sessionType, String sessionSubtype, String description, URI mediaUrl, String venue, String address, String tags, String seats, URI rsvpUrl, String ticketMessage, String active) throws ApiException {
        return this.modifySession(sessionKey, name, sessionStart, sessionEnd, sessionType, sessionSubtype, description, mediaUrl, venue, address, tags, seats, rsvpUrl, ticketMessage, active, Collections.emptyMap());
    }

    public String modifySession(String sessionKey, String name, String sessionStart, String sessionEnd, String sessionType, String sessionSubtype, String description, URI mediaUrl, String venue, String address, String tags, String seats, URI rsvpUrl, String ticketMessage, String active, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (sessionKey == null) {
            throw new ApiException(400, "Missing the required parameter 'sessionKey' when calling modifySession");
        }
        String localVarPath = "/api/session/mod";
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_key", sessionKey));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("name", name));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_start", sessionStart));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_end", sessionEnd));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_type", sessionType));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("session_subtype", sessionSubtype));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("description", description));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("media_url", mediaUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("venue", venue));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("address", address));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("tags", tags));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("seats", seats));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("rsvp_url", rsvpUrl));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("ticket_message", ticketMessage));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("active", active));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"text/html"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"ApiKeyAuth"};
        TypeReference<String> localVarReturnType = new TypeReference<String>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }
}

