/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.additions;

import java.io.Serializable;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@ManagedBean
@SessionScoped
public class CalculatorBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String color = "#0F0";
    @Min(value=7L)
    @Max(value=50L)
    @NotNull
    private int number1 = 42;
    @Max(value=100L)
    @Min(value=10L)
    @NotNull
    private int number2 = 65;
    @Max(value=100L)
    @Min(value=10L)
    @NotNull
    private int number3 = 33;
    private int sum = 0;

    public String add() {
        this.sum = this.number1 + this.number2;
        String msg = "Last calculation on the server side: " + this.number1 + "+" + this.number2 + "=" + this.sum;
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "", msg));
        return null;
    }

    public String getColor() {
        return this.color;
    }

    public int getNumber1() {
        return this.number1;
    }

    public int getNumber2() {
        return this.number2;
    }

    public int getNumber3() {
        ++this.number3;
        return this.number3;
    }

    public int getResult() {
        return this.sum;
    }

    public int getServerSideResult() {
        return this.sum;
    }

    public void setServerSideResult(int result) {
    }

    public void setRandomNumberFromServer(int random) {
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setNumber1(int number1) {
        this.number1 = number1;
    }

    public void setNumber2(int number2) {
        this.number2 = number2;
    }

    public void setNumber3(int i) {
        this.number3 = i;
    }

    public void setResult(int result) {
        this.sum = result;
    }

    public String getGridStyle() {
        return "font-weight:bold";
    }

    public String getHeaderText() {
        return "Header text from Angular Model. The last calculation on the server side was " + this.number1 + " + " + this.number2 + " = " + this.sum;
    }

    public String getResultCaption() {
        return "result";
    }

    public int getRandomNumberFromServer() {
        return new Double(Math.floor(Math.random() * 100.0)).intValue();
    }
}

