/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.lstar;

import de.learnlib.Resumable;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.lambda.lstar.LLambdaState;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.concept.FiniteRepresentation;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;

abstract class AbstractLLambda<M extends SuffixOutput<I, D>, I, D>
implements LearningAlgorithm<M, I, D>,
SupportsGrowingAlphabet<I>,
Resumable<LLambdaState<I, D>>,
FiniteRepresentation {
    final Alphabet<I> alphabet;
    final MembershipOracle<I, D> mqs;
    final MembershipOracle<I, D> ceqs;
    private final Set<Word<I>> shortPrefixes;
    private final Map<Word<I>, List<D>> rows;
    private final List<Word<I>> suffixes;

    AbstractLLambda(Alphabet<I> alphabet, MembershipOracle<I, D> mqs, MembershipOracle<I, D> ceqs, List<Word<I>> initialSuffixes) {
        this.alphabet = alphabet;
        this.mqs = mqs;
        this.ceqs = ceqs;
        this.suffixes = new ArrayList<Word<I>>(initialSuffixes);
        this.shortPrefixes = new HashSet<Word<I>>();
        this.rows = new HashMap<Word<I>, List<D>>();
    }

    abstract int maxSearchIndex(int var1);

    abstract void automatonFromTable();

    abstract boolean symbolInconsistency(Word<I> var1, Word<I> var2, I var3);

    protected abstract List<D> rowForState(Word<I> var1);

    public void startLearning() {
        this.initTable();
        this.learnLoop();
    }

    public boolean refineHypothesis(DefaultQuery<I, D> counterexample) {
        ArrayDeque<DefaultQuery<I, D>> witnesses = new ArrayDeque<DefaultQuery<I, D>>();
        witnesses.add(counterexample);
        boolean refined = false;
        while (!witnesses.isEmpty()) {
            boolean valid;
            DefaultQuery witness = (DefaultQuery)witnesses.getFirst();
            if (witness.getOutput() == null) {
                witness.answer(this.ceqs.answerQuery(witness.getPrefix(), witness.getSuffix()));
            }
            if (valid = MQUtil.isCounterexample((DefaultQuery)witness, (SuffixOutput)((SuffixOutput)this.getHypothesisModel()))) {
                this.analyzeCounterexample(witness, witnesses);
                this.learnLoop();
                refined = true;
                continue;
            }
            witnesses.pop();
        }
        assert (this.size() == this.shortPrefixes.size());
        return refined;
    }

    private void initTable() {
        Word epsilon = Word.epsilon();
        List<D> rowData = this.initRow(epsilon);
        this.rows.put(epsilon, rowData);
        this.addShortPrefix(epsilon);
    }

    private void analyzeCounterexample(DefaultQuery<I, D> counterexample, Deque<DefaultQuery<I, D>> witnesses) {
        int mid;
        SuffixOutput hyp = (SuffixOutput)this.getHypothesisModel();
        Word ceInput = counterexample.getInput();
        Word ua = null;
        int upper = this.maxSearchIndex(ceInput.length());
        int lower = 0;
        while (upper - lower > 1) {
            mid = (upper + lower) / 2;
            Word prefix = ceInput.prefix(mid);
            Word suffix = ceInput.suffix(ceInput.length() - mid);
            List<D> rowData = this.rowForState(prefix);
            boolean stillCe = false;
            for (Word<I> u : this.getShortPrefixes(rowData)) {
                Object hypOut;
                Object sysOut = this.ceqs.answerQuery(u, suffix);
                if (Objects.equals(sysOut, hypOut = hyp.computeSuffixOutput(u, (Iterable)suffix))) continue;
                ua = u.append(suffix.firstSymbol());
                lower = mid;
                stillCe = true;
                break;
            }
            if (stillCe) continue;
            upper = mid;
        }
        if (ua == null) {
            assert (upper == 1);
            ua = ceInput.prefix(1);
        }
        mid = (upper + lower) / 2;
        Word sprime = ceInput.suffix(ceInput.length() - (mid + 1));
        List<D> rnext = this.getRow(ua);
        for (Word<I> uprime : this.getShortPrefixes(rnext)) {
            witnesses.push(new DefaultQuery(uprime, sprime));
        }
        witnesses.push(new DefaultQuery(ua, sprime));
        this.addShortPrefix(ua);
    }

    private void learnLoop() {
        while (this.findInconsistency() || this.findUnclosedness()) {
            this.completeObservations();
        }
        this.automatonFromTable();
    }

    private boolean findInconsistency() {
        ArrayList<Word<I>> shortAsList = new ArrayList<Word<I>>(this.shortPrefixes);
        for (int left = 0; left < shortAsList.size() - 1; ++left) {
            for (int right = left + 1; right < shortAsList.size(); ++right) {
                if (!this.findInconsistency((Word)shortAsList.get(left), (Word)shortAsList.get(right))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findInconsistency(Word<I> u1, Word<I> u2) {
        List<D> rowData2;
        List<D> rowData1 = this.rows.get(u1);
        if (!Objects.equals(rowData1, rowData2 = this.rows.get(u2))) {
            return false;
        }
        for (Object a : this.alphabet) {
            rowData1 = this.rows.get(u1.append(a));
            rowData2 = this.rows.get(u2.append(a));
            assert (rowData1 != null && rowData2 != null);
            if (!rowData1.equals(rowData2)) {
                for (int i = 0; i < rowData1.size(); ++i) {
                    if (Objects.equals(rowData1.get(i), rowData2.get(i))) continue;
                    Word newSuffx = this.suffixes.get(i).prepend(a);
                    this.suffixes.add(newSuffx);
                    return true;
                }
            }
            if (!this.symbolInconsistency(u1, u2, a)) continue;
            return true;
        }
        return false;
    }

    private List<Word<I>> getShortPrefixes(Word<I> prefix) {
        List<D> rowData = this.rows.get(prefix);
        assert (rowData != null);
        return this.getShortPrefixes(rowData);
    }

    protected List<Word<I>> getShortPrefixes(List<D> rowData) {
        ArrayList<Word<I>> shortReps = new ArrayList<Word<I>>();
        for (Map.Entry<Word<I>, List<D>> e : this.rows.entrySet()) {
            if (!this.shortPrefixes.contains(e.getKey()) || !rowData.equals(e.getValue())) continue;
            shortReps.add(e.getKey());
        }
        return shortReps;
    }

    Collection<Word<I>> getShortPrefixes() {
        return this.shortPrefixes;
    }

    List<D> getRow(Word<I> key) {
        List<D> row = this.rows.get(key);
        assert (row != null);
        return row;
    }

    void addSuffix(Word<I> suffix) {
        this.suffixes.add(suffix);
    }

    private boolean findUnclosedness() {
        for (Word<I> prefix : this.rows.keySet()) {
            List<Word<I>> shortReps = this.getShortPrefixes(prefix);
            if (!shortReps.isEmpty()) continue;
            this.addShortPrefix(prefix);
            return true;
        }
        return false;
    }

    private void completeObservations() {
        for (Map.Entry<Word<I>, List<D>> e : this.rows.entrySet()) {
            List<D> rowData = this.completeRow(e.getKey(), e.getValue());
            e.setValue(rowData);
        }
    }

    private List<D> initRow(Word<I> prefix) {
        ArrayList<Object> rowData = new ArrayList<Object>(this.suffixes.size());
        for (Word<I> suffix : this.suffixes) {
            rowData.add(this.mqs.answerQuery(prefix, suffix));
        }
        return rowData;
    }

    private List<D> completeRow(Word<I> prefix, List<D> oldData) {
        if (this.suffixes.size() == oldData.size()) {
            return oldData;
        }
        ArrayList<Object> rowData = new ArrayList<Object>(this.suffixes.size());
        rowData.addAll(oldData);
        for (int i = oldData.size(); i < this.suffixes.size(); ++i) {
            rowData.add(this.mqs.answerQuery(prefix, this.suffixes.get(i)));
        }
        return rowData;
    }

    private void addShortPrefix(Word<I> shortPrefix) {
        assert (!this.shortPrefixes.contains(shortPrefix) && this.rows.containsKey(shortPrefix));
        this.shortPrefixes.add(shortPrefix);
        for (Object a : this.alphabet) {
            Word newPrefix = shortPrefix.append(a);
            List<D> rowData = this.initRow(newPrefix);
            this.rows.put(newPrefix, rowData);
        }
    }

    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet.asGrowingAlphabetOrThrowException().addSymbol(symbol);
        }
        if (!this.rows.isEmpty()) {
            for (Word<I> as : new ArrayList<Word<I>>(this.rows.keySet())) {
                if (!this.shortPrefixes.contains(as)) continue;
                Word lp = as.append(symbol);
                this.rows.put(lp, this.initRow(lp));
            }
            this.learnLoop();
        }
    }

    public LLambdaState<I, D> suspend() {
        return new LLambdaState<I, D>(this.shortPrefixes, this.rows, this.suffixes);
    }

    public void resume(LLambdaState<I, D> state) {
        this.shortPrefixes.clear();
        this.rows.clear();
        this.suffixes.clear();
        this.shortPrefixes.addAll(state.getShortPrefixes());
        this.rows.putAll(state.getRows());
        this.suffixes.addAll(state.getSuffixes());
        this.automatonFromTable();
    }
}

