/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.lstar;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.lambda.lstar.AbstractLLambda;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.fsa.DFA;
import net.automatalib.automaton.fsa.impl.CompactDFA;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.word.Word;

public class LLambdaDFA<I>
extends AbstractLLambda<DFA<?, I>, I, Boolean>
implements LearningAlgorithm.DFALearner<I> {
    private CompactDFA<I> hypothesis;
    private MutableMapping<Integer, List<Boolean>> hypStateMap;

    public LLambdaDFA(Alphabet<I> sigma, MembershipOracle<I, Boolean> mqo) {
        this(sigma, mqo, mqo);
    }

    public LLambdaDFA(Alphabet<I> sigma, MembershipOracle<I, Boolean> mqs, MembershipOracle<I, Boolean> ceqs) {
        super(sigma, mqs, ceqs, Collections.singletonList(Word.epsilon()));
    }

    @Override
    int maxSearchIndex(int ceLength) {
        return ceLength;
    }

    @Override
    boolean symbolInconsistency(Word<I> u1, Word<I> u2, I a) {
        return false;
    }

    @Override
    void automatonFromTable() {
        this.hypothesis = new CompactDFA(this.alphabet);
        HashMap stateMap = new HashMap();
        List rowData = this.getRow(Word.epsilon());
        Integer q = (Integer)this.hypothesis.addInitialState((Boolean)rowData.get(0));
        stateMap.put(rowData, q);
        for (Word word : this.getShortPrefixes()) {
            rowData = this.getRow(word);
            if (stateMap.containsKey(rowData)) continue;
            q = this.hypothesis.addState((Object)((Boolean)rowData.get(0)));
            stateMap.put(rowData, q);
        }
        this.hypStateMap = this.hypothesis.createStaticStateMapping();
        for (Map.Entry entry : stateMap.entrySet()) {
            List sig = (List)entry.getKey();
            Integer state = (Integer)entry.getValue();
            this.hypStateMap.put((Object)state, (Object)sig);
            Word u = this.getShortPrefixes(sig).get(0);
            for (Object a : this.alphabet) {
                List dstData = this.getRow(u.append(a));
                assert (dstData != null);
                Integer dst = (Integer)stateMap.get(dstData);
                this.hypothesis.setTransition(state, a, (Object)dst);
            }
        }
    }

    public int size() {
        return this.hypothesis.size();
    }

    @Override
    protected List<Boolean> rowForState(Word<I> input) {
        return (List)this.hypStateMap.get((Object)this.hypothesis.getState(input));
    }

    public DFA<?, I> getHypothesisModel() {
        return this.hypothesis;
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (this.hypothesis != null) {
            this.hypothesis.addAlphabetSymbol(symbol);
        }
        super.addAlphabetSymbol(symbol);
    }
}

