/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.lstar;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.lambda.lstar.AbstractLLambda;
import de.learnlib.oracle.MembershipOracle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.automaton.transducer.impl.CompactMealy;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.word.Word;

public class LLambdaMealy<I, O>
extends AbstractLLambda<MealyMachine<?, I, ?, O>, I, Word<O>>
implements LearningAlgorithm.MealyLearner<I, O> {
    private CompactMealy<I, O> hypothesis;
    private MutableMapping<Integer, List<Word<O>>> hypStateMap;

    public LLambdaMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqo) {
        this(alphabet, mqo, mqo);
    }

    public LLambdaMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqs, MembershipOracle<I, Word<O>> ceqs) {
        super(alphabet, mqs, ceqs, Collections.emptyList());
    }

    public int size() {
        return this.hypothesis.size();
    }

    @Override
    protected List<Word<O>> rowForState(Word<I> input) {
        return (List)this.hypStateMap.get((Object)((Integer)this.hypothesis.getState(input)));
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    @Override
    int maxSearchIndex(int ceLength) {
        return ceLength;
    }

    @Override
    boolean symbolInconsistency(Word<I> u1, Word<I> u2, I a) {
        Object o2;
        Word suff = Word.fromLetter(a);
        Object o1 = ((Word)this.mqs.answerQuery(u1, suff)).lastSymbol();
        if (!Objects.equals(o1, o2 = ((Word)this.mqs.answerQuery(u2, suff)).lastSymbol())) {
            this.addSuffix(suff);
            return true;
        }
        return false;
    }

    @Override
    void automatonFromTable() {
        this.hypothesis = new CompactMealy(this.alphabet);
        HashMap stateMap = new HashMap();
        List rowData = this.getRow(Word.epsilon());
        Integer q = (Integer)this.hypothesis.addInitialState();
        stateMap.put(rowData, q);
        for (Word word : this.getShortPrefixes()) {
            rowData = this.getRow(word);
            if (stateMap.containsKey(rowData)) continue;
            q = (Integer)this.hypothesis.addState();
            stateMap.put(rowData, q);
        }
        this.hypStateMap = this.hypothesis.createStaticStateMapping();
        for (Map.Entry entry : stateMap.entrySet()) {
            List sig = (List)entry.getKey();
            Integer state = (Integer)entry.getValue();
            this.hypStateMap.put((Object)state, (Object)sig);
            Word u = this.getShortPrefixes(sig).get(0);
            for (Object a : this.alphabet) {
                Word ua = u.append(a);
                List destData = this.getRow(ua);
                assert (destData != null);
                Integer dst = (Integer)stateMap.get(destData);
                Object o = ((Word)this.mqs.answerQuery(ua)).lastSymbol();
                this.hypothesis.setTransition((Object)state, a, (Object)dst, o);
            }
        }
    }

    @Override
    public void addAlphabetSymbol(I symbol) {
        if (this.hypothesis != null) {
            this.hypothesis.addAlphabetSymbol(symbol);
        }
        super.addAlphabetSymbol(symbol);
    }
}

