/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.lambda.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.lambda.ttt.dt.DTLeaf;
import de.learnlib.algorithm.lambda.ttt.pt.PTNode;
import de.learnlib.algorithm.lambda.ttt.pt.PrefixTree;
import de.learnlib.algorithm.lambda.ttt.st.SuffixTrie;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.concept.FiniteRepresentation;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;

public abstract class AbstractTTTLambda<M extends SuffixOutput<I, D>, I, D>
implements LearningAlgorithm<M, I, D>,
SupportsGrowingAlphabet<I>,
FiniteRepresentation {
    private final MembershipOracle<I, D> ceqs;
    private final Alphabet<I> alphabet;
    protected final SuffixTrie<I> strie;
    protected final PrefixTree<I, D> ptree;

    protected AbstractTTTLambda(Alphabet<I> alphabet, MembershipOracle<I, D> ceqs) {
        this.alphabet = alphabet;
        this.ceqs = ceqs;
        this.strie = new SuffixTrie();
        this.ptree = new PrefixTree();
    }

    protected abstract int maxSearchIndex(int var1);

    protected abstract DTLeaf<I, D> getState(Word<I> var1);

    protected abstract AbstractDecisionTree<I, D> dtree();

    public void startLearning() {
        assert (this.dtree() != null && this.getHypothesisModel() != null);
        this.dtree().sift(this.ptree.root());
        this.makeConsistent();
    }

    public boolean refineHypothesis(DefaultQuery<I, D> counterexample) {
        ArrayDeque<DefaultQuery<I, D>> witnesses = new ArrayDeque<DefaultQuery<I, D>>();
        witnesses.add(counterexample);
        boolean refined = false;
        while (MQUtil.isCounterexample(counterexample, (SuffixOutput)((SuffixOutput)this.getHypothesisModel()))) {
            boolean valid;
            DefaultQuery witness = (DefaultQuery)witnesses.getFirst();
            if (witness.getOutput() == null) {
                witness.answer(this.ceqs.answerQuery(witness.getPrefix(), witness.getSuffix()));
            }
            if (valid = MQUtil.isCounterexample((DefaultQuery)witness, (SuffixOutput)((SuffixOutput)this.getHypothesisModel()))) {
                this.analyzeCounterexample(witness, witnesses);
                this.makeConsistent();
                refined = true;
                continue;
            }
            witnesses.pop();
        }
        assert (this.size() == this.dtree().leaves().size());
        return refined;
    }

    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet.asGrowingAlphabetOrThrowException().addSymbol(symbol);
        }
        if (this.ptree.root().succ(symbol) == null) {
            List<DTLeaf<I, D>> leaves = this.dtree().leaves();
            for (DTLeaf<I, D> leaf : leaves) {
                PTNode<I, D> u = leaf.getShortPrefixes().get(0);
                assert (u != null);
                PTNode<I, D> ua = u.append(symbol);
                assert (ua != null);
                this.dtree().sift(ua);
            }
            this.makeConsistent();
        }
    }

    private void makeConsistent() {
        while (this.dtree().makeConsistent()) {
        }
    }

    private PTNode<I, D> longestShortPrefixOf(Word<I> ce) {
        PTNode<Object, D> cur = this.ptree.root();
        int i = 0;
        do {
            cur = cur.succ(ce.getSymbol(i++));
            assert (cur != null);
        } while (cur.state().getShortPrefixes().contains(cur) && i < ce.length());
        assert (!cur.state().getShortPrefixes().contains(cur));
        return cur;
    }

    private void analyzeCounterexample(DefaultQuery<I, D> counterexample, Deque<DefaultQuery<I, D>> witnesses) {
        int mid;
        SuffixOutput hyp = (SuffixOutput)this.getHypothesisModel();
        Word ce = counterexample.getInput();
        PTNode<Object, D> ua = null;
        PTNode<I, D> lsp = this.longestShortPrefixOf(ce);
        int upper = this.maxSearchIndex(ce.length());
        int lower = lsp.word().length() - 1;
        while (upper - lower > 1) {
            mid = (upper + lower) / 2;
            Word prefix = ce.prefix(mid);
            Word suffix = ce.suffix(ce.length() - mid);
            DTLeaf<I, D> q = this.getState(prefix);
            assert (q != null);
            boolean stillCe = false;
            for (PTNode<Object, D> pTNode : q.getShortPrefixes()) {
                Object hypOut;
                Object sysOut = this.ceqs.answerQuery(pTNode.word(), suffix);
                if (Objects.equals(sysOut, hypOut = hyp.computeSuffixOutput(pTNode.word(), (Iterable)suffix))) continue;
                ua = pTNode.succ(suffix.firstSymbol());
                lower = mid;
                stillCe = true;
                break;
            }
            if (stillCe) continue;
            upper = mid;
        }
        if (ua == null) {
            assert (lower == lsp.word().length() - 1);
            ua = lsp;
        }
        mid = (upper + lower) / 2;
        Word sprime = ce.suffix(ce.length() - (mid + 1));
        DTLeaf<I, D> qnext = this.getState(ua.word());
        for (PTNode<I, D> uprime : qnext.getShortPrefixes()) {
            witnesses.push(new DefaultQuery(uprime.word(), sprime));
        }
        witnesses.push(new DefaultQuery(ua.word(), sprime));
        ua.makeShortPrefix();
    }
}

