/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.dfa;

import de.learnlib.algorithm.lambda.ttt.dt.AbstractDTNode;
import de.learnlib.algorithm.lambda.ttt.dt.Children;
import de.learnlib.algorithm.lambda.ttt.dt.DTInnerNode;
import de.learnlib.algorithm.lambda.ttt.dt.DTLeaf;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.checkerframework.checker.nullness.qual.Nullable;

class ChildrenDFA<I>
implements Children<I, Boolean> {
    private @Nullable AbstractDTNode<I, Boolean> trueChild;
    private @Nullable AbstractDTNode<I, Boolean> falseChild;

    ChildrenDFA() {
    }

    @Override
    public @Nullable AbstractDTNode<I, Boolean> child(Boolean out) {
        return out != false ? this.trueChild : this.falseChild;
    }

    @Override
    public Boolean key(AbstractDTNode<I, Boolean> child) {
        if (child == this.trueChild) {
            return true;
        }
        if (child == this.falseChild) {
            return false;
        }
        throw new AssertionError((Object)"this should not be possible");
    }

    @Override
    public void addChild(Boolean out, AbstractDTNode<I, Boolean> child) {
        assert (this.child(out) == null);
        if (out.booleanValue()) {
            this.trueChild = child;
        } else {
            this.falseChild = child;
        }
    }

    @Override
    public void replace(DTLeaf<I, Boolean> oldNode, DTInnerNode<I, Boolean> newNode) {
        if (oldNode == this.trueChild) {
            this.trueChild = newNode;
        } else if (oldNode == this.falseChild) {
            this.falseChild = newNode;
        } else {
            throw new AssertionError((Object)"this should not be possible");
        }
    }

    @Override
    public Collection<AbstractDTNode<I, Boolean>> all() {
        if (this.trueChild != null && this.falseChild != null) {
            return Arrays.asList(this.trueChild, this.falseChild);
        }
        if (this.trueChild != null) {
            return Collections.singletonList(this.trueChild);
        }
        if (this.falseChild != null) {
            return Collections.singletonList(this.falseChild);
        }
        return Collections.emptyList();
    }
}

