/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.dt;

import de.learnlib.algorithm.lambda.ttt.dt.AbstractDTNode;
import de.learnlib.algorithm.lambda.ttt.dt.Children;
import de.learnlib.algorithm.lambda.ttt.dt.DTLeaf;
import de.learnlib.algorithm.lambda.ttt.pt.PTNode;
import de.learnlib.algorithm.lambda.ttt.st.STNode;
import de.learnlib.oracle.MembershipOracle;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.alphabet.Alphabet;

public abstract class AbstractDecisionTree<I, D> {
    private final STNode<I> stRoot;
    protected final MembershipOracle<I, D> mqOracle;
    protected final Alphabet<I> alphabet;
    protected AbstractDTNode<I, D> root;

    protected AbstractDecisionTree(Alphabet<I> alphabet, MembershipOracle<I, D> mqOracle, STNode<I> stRoot) {
        this.mqOracle = mqOracle;
        this.alphabet = alphabet;
        this.stRoot = stRoot;
    }

    protected abstract Children<I, D> newChildren();

    protected abstract D query(PTNode<I, D> var1, STNode<I> var2);

    public void sift(PTNode<I, D> prefix) {
        this.root.sift(prefix);
    }

    public void setRoot(AbstractDTNode<I, D> newRoot) {
        this.root = newRoot;
    }

    public List<DTLeaf<I, D>> leaves() {
        ArrayList list = new ArrayList();
        this.root.leaves(list);
        return list;
    }

    public boolean makeConsistent() {
        ArrayList leaves = new ArrayList();
        this.root.leaves(leaves);
        for (DTLeaf dTLeaf : leaves) {
            if (!dTLeaf.refineIfPossible()) continue;
            return true;
        }
        return false;
    }

    AbstractDTNode<I, D> root() {
        return this.root;
    }

    Alphabet<I> getAlphabet() {
        return this.alphabet;
    }

    STNode<I> newSuffix(I a) {
        return this.stRoot.prepend(a);
    }
}

