/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.dt;

import de.learnlib.algorithm.lambda.ttt.dt.AbstractDTNode;
import de.learnlib.algorithm.lambda.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.lambda.ttt.dt.Children;
import de.learnlib.algorithm.lambda.ttt.dt.DTInnerNode;
import de.learnlib.algorithm.lambda.ttt.pt.PTNode;
import de.learnlib.algorithm.lambda.ttt.st.STNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DTLeaf<I, D>
extends AbstractDTNode<I, D> {
    private final List<PTNode<I, D>> shortPrefixes = new ArrayList<PTNode<I, D>>();
    private final List<PTNode<I, D>> longPrefixes = new ArrayList<PTNode<I, D>>();

    public DTLeaf(@Nullable DTInnerNode<I, D> parent, AbstractDecisionTree<I, D> tree, PTNode<I, D> u) {
        super(parent, tree);
        this.shortPrefixes.add(u);
    }

    public List<PTNode<I, D>> getShortPrefixes() {
        return this.shortPrefixes;
    }

    public void addShortPrefix(PTNode<I, D> u) {
        this.shortPrefixes.add(u);
    }

    @Override
    void sift(PTNode<I, D> prefix) {
        prefix.setState(this);
        this.longPrefixes.add(prefix);
    }

    @Override
    void leaves(List<DTLeaf<I, D>> list) {
        list.add(this);
    }

    public boolean refineIfPossible() {
        PTNode<I, D> ref = this.shortPrefixes.get(0);
        for (int i = 1; i < this.shortPrefixes.size(); ++i) {
            if (!this.refineIfPossible(ref, this.shortPrefixes.get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean refineIfPossible(PTNode<I, D> u1, PTNode<I, D> u2) {
        I bestA = null;
        int vLength = 0;
        for (Object a : this.tree.getAlphabet()) {
            DTLeaf ua2;
            PTNode s1 = u1.succ(a);
            PTNode s2 = u2.succ(a);
            assert (s1 != null && s2 != null);
            DTLeaf ua1 = s1.state();
            if (ua1 == (ua2 = s2.state())) continue;
            int l = ((DTInnerNode)this.lca(ua1, ua2)).suffix().word().length();
            if (bestA != null && l >= vLength) continue;
            vLength = l;
            bestA = (I)a;
        }
        if (bestA != null) {
            this.split(u1, u2, bestA);
            return true;
        }
        return false;
    }

    public void makeShortPrefix(PTNode<I, D> uNew) {
        assert (!this.shortPrefixes.contains(uNew));
        assert (this.longPrefixes.contains(uNew));
        this.longPrefixes.remove(uNew);
        this.shortPrefixes.add(uNew);
        for (Object a : this.tree.getAlphabet()) {
            PTNode ua = uNew.append(a);
            this.tree.root().sift(ua);
        }
    }

    public void split(PTNode<I, D> u1, PTNode<I, D> u2, I a) {
        DTLeaf<I, D> ua2;
        PTNode<I, D> s1 = u1.succ(a);
        PTNode<I, D> s2 = u2.succ(a);
        assert (s1 != null && s2 != null);
        DTLeaf<I, D> ua1 = s1.state();
        AbstractDTNode<I, D> n = this.lca(ua1, ua2 = s2.state());
        STNode<I> av = n instanceof DTInnerNode ? ((DTInnerNode)n).suffix().prepend(a) : this.tree.newSuffix(a);
        Children newChildren = this.tree.newChildren();
        DTInnerNode newInner = new DTInnerNode(this.parent, this.tree, newChildren, av);
        HashMap newLeaves = new HashMap();
        for (PTNode pTNode : this.shortPrefixes) {
            D out = this.tree.query(pTNode, av);
            DTLeaf leaf = (DTLeaf)newLeaves.get(out);
            if (leaf == null) {
                leaf = new DTLeaf(newInner, this.tree, pTNode);
                newLeaves.put(out, leaf);
            } else {
                leaf.addShortPrefix(pTNode);
            }
            pTNode.setState(leaf);
        }
        for (Map.Entry entry : newLeaves.entrySet()) {
            newChildren.addChild(entry.getKey(), (AbstractDTNode)entry.getValue());
        }
        if (this.parent != null) {
            this.parent.replace(this, newInner);
        } else {
            this.tree.setRoot(newInner);
        }
        for (PTNode pTNode : this.longPrefixes) {
            newInner.sift(pTNode);
        }
    }

    private AbstractDTNode<I, D> lca(DTLeaf<I, D> n1, DTLeaf<I, D> n2) {
        AbstractDTNode t2;
        AbstractDTNode t1;
        Iterator p1 = n1.path().iterator();
        Iterator p2 = n2.path().iterator();
        AbstractDTNode lca = this.tree.root();
        while (p1.hasNext() && p2.hasNext() && (t1 = p1.next()) == (t2 = p2.next())) {
            lca = t1;
        }
        return lca;
    }
}

