/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.mealy;

import de.learnlib.algorithm.lambda.ttt.dt.DTLeaf;
import de.learnlib.algorithm.lambda.ttt.mealy.DecisionTreeMealy;
import de.learnlib.algorithm.lambda.ttt.mealy.MealyTransition;
import de.learnlib.algorithm.lambda.ttt.pt.PTNode;
import de.learnlib.algorithm.lambda.ttt.pt.PrefixTree;
import java.util.Collection;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

class HypothesisMealy<I, O>
implements MealyMachine<DTLeaf<I, Word<O>>, I, MealyTransition<I, O>, O> {
    private final PrefixTree<I, Word<O>> ptree;
    private final DecisionTreeMealy<I, O> dtree;

    HypothesisMealy(PrefixTree<I, Word<O>> ptree, DecisionTreeMealy<I, O> dtree) {
        this.ptree = ptree;
        this.dtree = dtree;
    }

    public Collection<DTLeaf<I, Word<O>>> getStates() {
        return this.dtree.leaves();
    }

    public O getTransitionOutput(MealyTransition<I, O> o) {
        return (O)this.dtree.getOutput(o.source, o.input).lastSymbol();
    }

    public MealyTransition<I, O> getTransition(DTLeaf<I, Word<O>> iWordDTLeaf, I i) {
        return new MealyTransition<I, O>(iWordDTLeaf, i);
    }

    public DTLeaf<I, Word<O>> getSuccessor(MealyTransition<I, O> o) {
        PTNode u = o.source.getShortPrefixes().get(0);
        assert (u != null);
        PTNode ua = u.succ(o.input);
        assert (ua != null);
        DTLeaf dst = ua.state();
        assert (dst != null);
        return dst;
    }

    public DTLeaf<I, Word<O>> getInitialState() {
        return this.ptree.root().state();
    }
}

