/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.mealy;

import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.lambda.ttt.AbstractTTTLambda;
import de.learnlib.algorithm.lambda.ttt.dt.AbstractDecisionTree;
import de.learnlib.algorithm.lambda.ttt.dt.DTLeaf;
import de.learnlib.algorithm.lambda.ttt.mealy.DecisionTreeMealy;
import de.learnlib.algorithm.lambda.ttt.mealy.HypothesisMealy;
import de.learnlib.oracle.MembershipOracle;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.word.Word;

public class TTTLambdaMealy<I, O>
extends AbstractTTTLambda<MealyMachine<?, I, ?, O>, I, Word<O>>
implements LearningAlgorithm.MealyLearner<I, O> {
    private final HypothesisMealy<I, O> hypothesis;
    private final DecisionTreeMealy<I, O> dtree;

    public TTTLambdaMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqo) {
        this(alphabet, mqo, mqo);
    }

    public TTTLambdaMealy(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> mqs, MembershipOracle<I, Word<O>> ceqs) {
        super(alphabet, ceqs);
        this.dtree = new DecisionTreeMealy<I, O>(mqs, alphabet, this.strie.root());
        DTLeaf<I, O> dtRoot = new DTLeaf<I, O>(null, this.dtree, this.ptree.root());
        this.dtree.setRoot(dtRoot);
        this.ptree.root().setState(dtRoot);
        for (Object a : alphabet) {
            this.dtree.sift(this.ptree.root().append(a));
        }
        this.hypothesis = new HypothesisMealy<I, O>(this.ptree, this.dtree);
    }

    @Override
    protected int maxSearchIndex(int ceLength) {
        return ceLength - 1;
    }

    @Override
    protected DTLeaf<I, Word<O>> getState(Word<I> prefix) {
        return (DTLeaf)this.hypothesis.getState((Iterable)prefix);
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        return this.hypothesis;
    }

    @Override
    protected AbstractDecisionTree<I, Word<O>> dtree() {
        return this.dtree;
    }

    public int size() {
        return this.hypothesis.size();
    }
}

