/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.pt;

import de.learnlib.algorithm.lambda.ttt.dt.DTLeaf;
import de.learnlib.algorithm.lambda.ttt.pt.PTNode;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PTNodeImpl<I, D>
implements PTNode<I, D> {
    private final @Nullable PTNodeImpl<I, D> parent;
    private final @Nullable I symbol;
    private final Map<I, PTNodeImpl<I, D>> children;
    private DTLeaf<I, D> state;

    public PTNodeImpl(@Nullable PTNodeImpl<I, D> parent, @Nullable I symbol) {
        this.parent = parent;
        this.symbol = symbol;
        this.children = new HashMap<I, PTNodeImpl<I, D>>();
    }

    @Override
    public Word<I> word() {
        return this.toWord(Word.epsilon());
    }

    @Override
    public PTNode<I, D> append(I i) {
        assert (!this.children.containsKey(i));
        PTNodeImpl<I, D> n = new PTNodeImpl<I, D>(this, i);
        this.children.put(i, n);
        return n;
    }

    @Override
    public void setState(DTLeaf<I, D> node) {
        this.state = node;
    }

    @Override
    public DTLeaf<I, D> state() {
        return this.state;
    }

    private Word<I> toWord(Word<I> suffix) {
        if (this.symbol == null || this.parent == null) {
            return suffix;
        }
        return super.toWord(suffix.prepend(this.symbol));
    }

    @Override
    public @Nullable PTNode<I, D> succ(I a) {
        return this.children.get(a);
    }

    @Override
    public void makeShortPrefix() {
        this.state.makeShortPrefix(this);
    }
}

