/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.lambda.ttt.st;

import de.learnlib.algorithm.lambda.ttt.st.STNode;
import java.util.HashMap;
import java.util.Map;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

class STNodeImpl<I>
implements STNode<I> {
    private final @Nullable STNodeImpl<I> parent;
    private final @Nullable I symbol;
    private final Map<I, STNodeImpl<I>> children;

    STNodeImpl(@Nullable STNodeImpl<I> parent, @Nullable I symbol) {
        this.parent = parent;
        this.symbol = symbol;
        this.children = new HashMap<I, STNodeImpl<I>>();
    }

    @Override
    public Word<I> word() {
        return this.toWord(Word.epsilon());
    }

    private Word<I> toWord(Word<I> prefix) {
        if (this.symbol == null || this.parent == null) {
            return prefix;
        }
        return super.toWord(prefix.append(this.symbol));
    }

    @Override
    public STNodeImpl<I> prepend(I a) {
        return this.children.computeIfAbsent(a, a1 -> new STNodeImpl<Object>(this, a1));
    }
}

