/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.generator.data;

import com.squareup.kotlinpoet.AnnotationSpec;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import dev.goquick.sqlitenow.gradle.LoggerKt;
import dev.goquick.sqlitenow.gradle.context.GeneratorContext;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructJoinedEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructPropertyEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructResultEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructResultFileEmitter;
import dev.goquick.sqlitenow.gradle.generator.data.DataStructUtils;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedExecuteStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedStatement;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationResolver;
import dev.goquick.sqlitenow.gradle.processing.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.processing.SharedResultManager;
import dev.goquick.sqlitenow.gradle.processing.StatementAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.StatementProcessingHelper;
import dev.goquick.sqlitenow.gradle.processing.StatementProcessor;
import dev.goquick.sqlitenow.gradle.processing.StatementUtils;
import dev.goquick.sqlitenow.gradle.sqlinspect.AssociatedColumn;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateTableStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.CreateViewStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeferredStatementExecutor;
import dev.goquick.sqlitenow.gradle.sqlinspect.DeleteStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.ExecuteStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.InsertStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.SelectStatement;
import dev.goquick.sqlitenow.gradle.sqlinspect.UpdateStatement;
import dev.goquick.sqlitenow.gradle.util.FileGenerationHelper;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import dev.goquick.sqlitenow.gradle.util.StringUtilsKt;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001c\u00100\u001a\b\u0012\u0004\u0012\u0002010\r2\f\u00102\u001a\b\u0012\u0004\u0012\u0002010\rH\u0002J\u0016\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u00020!H\u0002J\u0006\u00109\u001a\u00020:J\u0010\u0010;\u001a\u0002072\u0006\u00108\u001a\u00020!H\u0002J\u0016\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00072\u0006\u00108\u001a\u00020!J\u001a\u0010?\u001a\u0004\u0018\u00010\u00072\u0006\u0010>\u001a\u00020\u00072\u0006\u00108\u001a\u00020!H\u0002J\u0010\u0010@\u001a\u00020\u00072\u0006\u00108\u001a\u00020!H\u0002J\u0016\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00070B2\u0006\u00108\u001a\u00020!H\u0002J\u001a\u0010C\u001a\u0004\u0018\u00010D2\u0006\u00108\u001a\u00020!2\u0006\u0010>\u001a\u00020\u0007H\u0002J\u0012\u0010E\u001a\u00020=2\b\u0010F\u001a\u0004\u0018\u00010GH\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0\r0 \u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Ldev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator;", "", "conn", "Ljava/sql/Connection;", "queriesDir", "Ljava/io/File;", "packageName", "", "outputDir", "statementExecutors", "", "Ldev/goquick/sqlitenow/gradle/sqlinspect/DeferredStatementExecutor;", "providedCreateTableStatements", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "<init>", "(Ljava/sql/Connection;Ljava/io/File;Ljava/lang/String;Ljava/io/File;Ljava/util/List;Ljava/util/List;)V", "createTableStatements", "getCreateTableStatements", "()Ljava/util/List;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "getCreateViewStatements", "annotationResolver", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver;", "fileGenerationHelper", "Ldev/goquick/sqlitenow/gradle/util/FileGenerationHelper;", "stmtProcessingHelper", "Ldev/goquick/sqlitenow/gradle/processing/StatementProcessingHelper;", "sharedResultManager", "Ldev/goquick/sqlitenow/gradle/processing/SharedResultManager;", "nsWithStatements", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedStatement;", "getNsWithStatements", "()Ljava/util/Map;", "generatorContext", "Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;", "getGeneratorContext$sqlitenow_gradle_plugin", "()Ldev/goquick/sqlitenow/gradle/context/GeneratorContext;", "propertyEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructPropertyEmitter;", "joinedEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructJoinedEmitter;", "resultEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultEmitter;", "resultFileEmitter", "Ldev/goquick/sqlitenow/gradle/generator/data/DataStructResultFileEmitter;", "sortViewsByDependencies", "Ldev/goquick/sqlitenow/gradle/sqlinspect/CreateViewStatementExecutor;", "viewExecutors", "generateNamespaceDataStructuresCode", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "namespace", "generateQueryObject", "Lcom/squareup/kotlinpoet/TypeSpec;", "statement", "generateCode", "", "generateParameterDataClass", "inferParameterType", "Lcom/squareup/kotlinpoet/TypeName;", "paramName", "getCastTypeForParameter", "getSqlFromStatement", "getAffectedTablesFromStatement", "", "getAssociatedColumn", "Ldev/goquick/sqlitenow/gradle/sqlinspect/AssociatedColumn;", "handleCollectionParameterType", "column", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement$Column;", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nDataStructCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStructCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,467:1\n808#2,11:468\n1557#2:479\n1628#2,3:480\n808#2,11:483\n1557#2:494\n1628#2,3:495\n1202#2,2:498\n1230#2,4:500\n1863#2,2:505\n1863#2:507\n774#2:508\n865#2,2:509\n1863#2:511\n1864#2:519\n1864#2:520\n1863#2,2:528\n1557#2:530\n1628#2,3:531\n774#2:534\n865#2,2:535\n1611#2,9:537\n1863#2:546\n1864#2:548\n1620#2:549\n1863#2,2:550\n1557#2:552\n1628#2,3:553\n1#3:504\n1#3:547\n381#4,7:512\n535#4:521\n520#4,6:522\n*S KotlinDebug\n*F\n+ 1 DataStructCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/generator/data/DataStructCodeGenerator\n*L\n50#1:468,11\n51#1:479\n51#1:480,3\n65#1:483,11\n67#1:494\n67#1:495,3\n108#1:498,2\n108#1:500,4\n112#1:505,2\n114#1:507\n116#1:508\n116#1:509,2\n117#1:511\n117#1:519\n114#1:520\n128#1:528,2\n135#1:530\n135#1:531,3\n135#1:534\n135#1:535,2\n139#1:537,9\n139#1:546\n139#1:548\n139#1:549\n270#1:550,2\n314#1:552\n314#1:553,3\n139#1:547\n118#1:512,7\n123#1:521\n123#1:522,6\n*E\n"})
public class DataStructCodeGenerator {
    @NotNull
    private final File outputDir;
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;
    @NotNull
    private final List<AnnotatedCreateViewStatement> createViewStatements;
    @NotNull
    private final FieldAnnotationResolver annotationResolver;
    @NotNull
    private final FileGenerationHelper fileGenerationHelper;
    @NotNull
    private final StatementProcessingHelper stmtProcessingHelper;
    @NotNull
    private final SharedResultManager sharedResultManager;
    @NotNull
    private final Map<String, List<AnnotatedStatement>> nsWithStatements;
    @NotNull
    private final GeneratorContext generatorContext;
    @NotNull
    private final DataStructPropertyEmitter propertyEmitter;
    @NotNull
    private final DataStructJoinedEmitter joinedEmitter;
    @NotNull
    private final DataStructResultEmitter resultEmitter;
    @NotNull
    private final DataStructResultFileEmitter resultFileEmitter;

    /*
     * WARNING - void declaration
     */
    public DataStructCodeGenerator(@NotNull Connection conn, @NotNull File queriesDir, @NotNull String packageName, @NotNull File outputDir, @NotNull List<DeferredStatementExecutor> statementExecutors, @Nullable List<AnnotatedCreateTableStatement> providedCreateTableStatements) {
        void $this$mapTo$iv$iv;
        void $this$createViewStatements_u24lambda_u240;
        void $this$filterIsInstanceTo$iv$iv;
        DataStructCodeGenerator dataStructCodeGenerator;
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        Intrinsics.checkNotNullParameter((Object)queriesDir, (String)"queriesDir");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(statementExecutors, (String)"statementExecutors");
        this.outputDir = outputDir;
        DataStructCodeGenerator dataStructCodeGenerator2 = this;
        List list = providedCreateTableStatements;
        if (list == null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            void $this$filterIsInstanceTo$iv$iv2;
            Iterable $this$filterIsInstance$iv;
            Iterable iterable = statementExecutors;
            dataStructCodeGenerator = dataStructCodeGenerator2;
            boolean $i$f$filterIsInstance = false;
            void var9_11 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                if (!(element$iv$iv instanceof CreateTableStatementExecutor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                AnnotatedCreateTableStatement annotatedCreateTableStatement;
                void it;
                CreateTableStatementExecutor createTableStatementExecutor = (CreateTableStatementExecutor)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                try {
                    AnnotatedStatement annotatedStatement = it.execute(conn);
                    Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement");
                    annotatedCreateTableStatement = (AnnotatedCreateTableStatement)annotatedStatement;
                }
                catch (Exception e) {
                    LoggerKt.getLogger().error(StringsKt.trimMargin$default((String)("|\n                    |Failed to execute CREATE TABLE statement:\n                    |" + it.reportContext() + "\n                    "), null, (int)1, null));
                    throw e;
                }
                collection.add(annotatedCreateTableStatement);
            }
            list = (List)destination$iv$iv;
            dataStructCodeGenerator2 = dataStructCodeGenerator;
        }
        dataStructCodeGenerator2.createTableStatements = list;
        DataStructCodeGenerator $i$f$map = this;
        dataStructCodeGenerator = this;
        boolean bl = false;
        Iterable $this$filterIsInstance$iv = statementExecutors;
        boolean $i$f$filterIsInstance = false;
        Iterator iterator = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof CreateViewStatementExecutor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List viewExecs = (List)destination$iv$iv;
        List<CreateViewStatementExecutor> sorted = super.sortViewsByDependencies(viewExecs);
        Iterable $this$map$iv = sorted;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AnnotatedCreateViewStatement annotatedCreateViewStatement;
            void it;
            CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            try {
                AnnotatedStatement annotatedStatement = it.execute(conn);
                Intrinsics.checkNotNull((Object)annotatedStatement, (String)"null cannot be cast to non-null type dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement");
                annotatedCreateViewStatement = (AnnotatedCreateViewStatement)annotatedStatement;
            }
            catch (Exception e) {
                LoggerKt.getLogger().error(StringsKt.trimIndent((String)("\n                    |Failed to execute CREATE VIEW statement:\n                    |" + it.reportContext() + "\n                    ")));
                throw e;
            }
            collection.add(annotatedCreateViewStatement);
        }
        dataStructCodeGenerator.createViewStatements = (List)destination$iv$iv2;
        this.annotationResolver = new FieldAnnotationResolver(this.getCreateTableStatements(), this.createViewStatements);
        this.fileGenerationHelper = new FileGenerationHelper(packageName, this.outputDir);
        this.stmtProcessingHelper = new StatementProcessingHelper(conn, this.annotationResolver);
        this.sharedResultManager = new SharedResultManager();
        this.nsWithStatements = this.stmtProcessingHelper.processQueriesDirectory(queriesDir);
        this.generatorContext = new GeneratorContext(packageName, this.outputDir, this.getCreateTableStatements(), this.createViewStatements, this.nsWithStatements);
        this.propertyEmitter = new DataStructPropertyEmitter();
        this.joinedEmitter = new DataStructJoinedEmitter(this.generatorContext);
        this.resultEmitter = new DataStructResultEmitter(this.generatorContext, this.propertyEmitter);
        this.resultFileEmitter = new DataStructResultFileEmitter(this.generatorContext, this.joinedEmitter, this.resultEmitter, this.sharedResultManager, this.outputDir);
    }

    public /* synthetic */ DataStructCodeGenerator(Connection connection, File file, String string, File file2, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list2 = null;
        }
        this(connection, file, string, file2, list, list2);
    }

    @NotNull
    public List<AnnotatedCreateTableStatement> getCreateTableStatements() {
        return this.createTableStatements;
    }

    @NotNull
    public final List<AnnotatedCreateViewStatement> getCreateViewStatements() {
        return this.createViewStatements;
    }

    @NotNull
    public final Map<String, List<AnnotatedStatement>> getNsWithStatements() {
        return this.nsWithStatements;
    }

    @NotNull
    public final GeneratorContext getGeneratorContext$sqlitenow_gradle_plugin() {
        return this.generatorContext;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CreateViewStatementExecutor> sortViewsByDependencies(List<CreateViewStatementExecutor> viewExecutors) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Object element$iv;
        Object element$iv22;
        Object object;
        Map $this$associateByTo$iv$iv;
        if (viewExecutors.size() <= 1) {
            return viewExecutors;
        }
        Iterable $this$associateBy$iv = viewExecutors;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Iterator it;
            Object element$iv$iv = iterator.next();
            CreateViewStatementExecutor createViewStatementExecutor = (CreateViewStatementExecutor)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(((CreateViewStatementExecutor)((Object)it)).viewName(), element$iv$iv);
        }
        Map nameToExec = destination$iv$iv;
        Set viewNames = CollectionsKt.toSet((Iterable)nameToExec.keySet());
        Map adj = new LinkedHashMap();
        Map $this$sortViewsByDependencies_u24lambda_u241 = $this$associateByTo$iv$iv = (Map)new LinkedHashMap();
        boolean bl = false;
        Iterable $this$forEach$iv = viewNames;
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv) {
            String it = (String)element$iv3;
            boolean bl2 = false;
            $this$sortViewsByDependencies_u24lambda_u241.put(it, 0);
        }
        Map indeg = $this$associateByTo$iv$iv;
        Iterable $this$forEach$iv2 = viewExecutors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv22 : $this$forEach$iv2) {
            Object element$iv$iv;
            Iterator $this$filterTo$iv$iv2;
            CreateViewStatementExecutor exec = (CreateViewStatementExecutor)element$iv22;
            boolean bl3 = false;
            String v = exec.viewName();
            Iterable $this$filter$iv = exec.referencedTableOrViewNames();
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                String it = (String)element$iv$iv;
                boolean bl4 = false;
                if (!viewNames.contains(it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List deps = (List)destination$iv$iv2;
            Iterable $this$forEach$iv3 = deps;
            boolean $i$f$forEach3 = false;
            $this$filterTo$iv$iv2 = $this$forEach$iv3.iterator();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Object object2;
                Map $this$getOrPut$iv;
                element$iv = $this$filterTo$iv$iv2.next();
                String dep = (String)element$iv;
                boolean bl5 = false;
                element$iv$iv = adj;
                Object key$iv = dep;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl6 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(v);
                $this$getOrPut$iv = indeg;
                Integer n = (Integer)indeg.get(v);
                key$iv = (n != null ? n : 0) + 1;
                $this$getOrPut$iv.put(v, key$iv);
            }
        }
        Map $this$filter$iv = indeg;
        boolean $i$f$filter = false;
        element$iv22 = $this$filter$iv;
        Map destination$iv$iv3 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator v = $this$filterTo$iv$iv.entrySet().iterator();
        while (v.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = v.next();
            boolean bl7 = false;
            if (!(((Number)it.getValue()).intValue() == 0)) continue;
            destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Collection collection = destination$iv$iv3.keySet();
        ArrayDeque queue = new ArrayDeque(collection);
        List orderedNames = new ArrayList();
        while (!((Collection)queue).isEmpty()) {
            String u = (String)queue.removeFirst();
            orderedNames.add(u);
            List list = (List)adj.get(u);
            if (list == null) continue;
            Iterable $this$forEach$iv4 = list;
            boolean $i$f$forEach4 = false;
            for (Map.Entry element$iv4 : $this$forEach$iv4) {
                String w = (String)((Object)element$iv4);
                boolean bl8 = false;
                element$iv = indeg;
                Integer n = (Integer)indeg.get(w);
                Integer dep = (n != null ? n : 0) - 1;
                element$iv.put((String)w, (Integer)dep);
                Integer n2 = (Integer)indeg.get(w);
                if ((n2 != null ? n2 : 0) != 0) continue;
                queue.add((Object)w);
            }
        }
        if (orderedNames.size() < viewExecutors.size()) {
            void $this$filterTo$iv$iv3;
            void $this$filter$iv2;
            String it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = viewExecutors;
            boolean $i$f$map = false;
            Iterable $i$f$forEach4 = $this$map$iv;
            Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                element$iv = (CreateViewStatementExecutor)item$iv$iv;
                object = destination$iv$iv4;
                boolean bl9 = false;
                object.add(((CreateViewStatementExecutor)((Object)it)).viewName());
            }
            $this$map$iv = (List)destination$iv$iv4;
            boolean $i$f$filter2 = false;
            $this$mapTo$iv$iv = $this$filter$iv2;
            destination$iv$iv4 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                it = (String)element$iv$iv;
                boolean bl10 = false;
                if (!(!orderedNames.contains(it))) continue;
                destination$iv$iv4.add(element$iv$iv);
            }
            List remaining = (List)destination$iv$iv4;
            orderedNames.addAll(remaining);
        }
        Iterable $this$mapNotNull$iv = orderedNames;
        boolean $i$f$mapNotNull = false;
        Iterable $i$f$filter2 = $this$mapNotNull$iv;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach5 = false;
        Iterator iterator3 = $this$forEach$iv$iv$iv.iterator();
        while (iterator3.hasNext()) {
            CreateViewStatementExecutor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator3.next();
            boolean bl11 = false;
            String it = (String)element$iv$iv;
            boolean bl12 = false;
            if ((CreateViewStatementExecutor)nameToExec.get(it) == null) continue;
            boolean bl13 = false;
            destination$iv$iv5.add(it$iv$iv);
        }
        return (List)destination$iv$iv5;
    }

    @NotNull
    public final FileSpec.Builder generateNamespaceDataStructuresCode(@NotNull String namespace, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String fileName = StringUtilsKt.pascalize(namespace) + "Query";
        Object[] objectArray = new String[]{"Suppress"};
        ClassName className = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[]{"UNNECESSARY_NOT_NULL_ASSERTION"};
        FileSpec.Builder builder = FileSpec.Companion.builder(packageName, fileName).addFileComment("Generated code for " + namespace + " namespace queries", new Object[0]).addFileComment("\nDo not modify this file manually", new Object[0]).addAnnotation(AnnotationSpec.Companion.builder(className).addMember("%S", objectArray).build());
        objectArray = new String[]{"OptIn"};
        ClassName className2 = new ClassName("kotlin", (String[])objectArray);
        objectArray = new Object[1];
        String[] stringArray = new String[]{"ExperimentalUuidApi"};
        objectArray[0] = new ClassName("kotlin.uuid", stringArray);
        FileSpec.Builder fileSpecBuilder = builder.addAnnotation(AnnotationSpec.Companion.builder(className2).addMember("%T::class", objectArray).build());
        String capitalizedNamespace = StringUtilsKt.pascalize(namespace) + "Query";
        TypeSpec.Builder namespaceObject = TypeSpec.Companion.objectBuilder(capitalizedNamespace).addKdoc("Contains queries for the " + namespace + " namespace", new Object[0]);
        List list = this.nsWithStatements.get(namespace);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List allStatements = list;
        StatementProcessor statementProcessor = new StatementProcessor(allStatements);
        Map sharedResultsWithContext = new LinkedHashMap();
        statementProcessor.processStatements((Function1<? super AnnotatedSelectStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$0(this, namespace, sharedResultsWithContext, namespaceObject, arg_0)), (Function1<? super AnnotatedExecuteStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$1(this, namespaceObject, arg_0)));
        statementProcessor.processStatements((Function1<? super AnnotatedSelectStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$2(this, namespace, packageName, arg_0)), (Function1<? super AnnotatedExecuteStatement, Unit>)((Function1)arg_0 -> DataStructCodeGenerator.generateNamespaceDataStructuresCode$lambda$3(this, namespace, packageName, arg_0)));
        fileSpecBuilder.addType(namespaceObject.build());
        return fileSpecBuilder;
    }

    private final TypeSpec generateQueryObject(AnnotatedStatement statement) {
        String className = statement.getDataClassName();
        TypeSpec.Builder queryObjectBuilder = TypeSpec.Companion.objectBuilder(className).addKdoc("Contains SQL, parameters, and result types for the " + statement.getName() + " query.", new Object[0]);
        String sql = this.getSqlFromStatement(statement);
        Object[] objectArray = new KModifier[]{KModifier.CONST};
        PropertySpec.Builder builder = PropertySpec.Companion.builder("SQL", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]).addModifiers((KModifier[])objectArray);
        objectArray = new Object[]{sql};
        PropertySpec sqlProperty = builder.initializer("%S", objectArray).addKdoc("The SQL query string for " + statement.getName() + ".", new Object[0]).build();
        queryObjectBuilder.addProperty(sqlProperty);
        Set<String> affectedTables = this.getAffectedTablesFromStatement(statement);
        String[] stringArray = new String[]{"Set"};
        ClassName className2 = new ClassName("kotlin.collections", stringArray);
        stringArray = new TypeName[1];
        Object[] objectArray2 = new String[]{"String"};
        stringArray[0] = new ClassName("kotlin", (String[])objectArray2);
        ParameterizedTypeName affectedTablesType = ParameterizedTypeName.Companion.get(className2, (TypeName[])stringArray);
        objectArray2 = new Object[]{CollectionsKt.joinToString$default((Iterable)affectedTables, (CharSequence)", ", null, null, (int)0, null, DataStructCodeGenerator::generateQueryObject$lambda$0, (int)30, null)};
        PropertySpec affectedTablesProperty = PropertySpec.Companion.builder("affectedTables", (TypeName)affectedTablesType, new KModifier[0]).initializer("setOf(%L)", objectArray2).addKdoc("Set of table names that are affected by the " + statement.getName() + " query.", new Object[0]).build();
        queryObjectBuilder.addProperty(affectedTablesProperty);
        List<String> namedParameters = StatementUtils.INSTANCE.getNamedParameters(statement);
        if (!((Collection)namedParameters).isEmpty()) {
            TypeSpec paramsDataClass = this.generateParameterDataClass(statement);
            queryObjectBuilder.addType(paramsDataClass);
        }
        return queryObjectBuilder.build();
    }

    public final void generateCode() {
        this.fileGenerationHelper.generateFiles(this.nsWithStatements.keySet(), (Function2<? super String, ? super String, FileSpec.Builder>)((Function2)(arg_0, arg_1) -> DataStructCodeGenerator.generateCode$lambda$0(this, arg_0, arg_1)));
    }

    private final TypeSpec generateParameterDataClass(AnnotatedStatement statement) {
        KModifier[] kModifierArray = new KModifier[]{KModifier.DATA};
        TypeSpec.Builder paramClassBuilder = TypeSpec.Companion.classBuilder("Params").addModifiers(kModifierArray).addKdoc("Data class for " + statement.getName() + " query parameters.", new Object[0]);
        FunSpec.Builder paramConstructorBuilder = FunSpec.Companion.constructorBuilder();
        PropertyNameGeneratorType propertyNameGeneratorType = statement.getAnnotations().getPropertyNameGenerator();
        Set<String> uniqueParams = StatementUtils.INSTANCE.getAllNamedParameters(statement);
        List paramCollectedProps = new ArrayList();
        Iterable $this$forEach$iv = uniqueParams;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String paramName = (String)element$iv;
            boolean bl = false;
            String propertyName = propertyNameGeneratorType.convertToPropertyName(paramName);
            TypeName propertyType = this.inferParameterType(paramName, statement);
            ParameterSpec parameter = ParameterSpec.Companion.builder(propertyName, propertyType, new KModifier[0]).build();
            paramConstructorBuilder.addParameter(parameter);
            PropertySpec property = PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(propertyName, new Object[0]).build();
            paramCollectedProps.add(property);
            paramClassBuilder.addProperty(property);
        }
        paramClassBuilder.primaryConstructor(paramConstructorBuilder.build());
        DataStructUtils.INSTANCE.addArraySafeEqualsAndHashCodeIfNeeded(paramClassBuilder, "Params", paramCollectedProps);
        return paramClassBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeName inferParameterType(@NotNull String paramName, @NotNull AnnotatedStatement statement) {
        SelectStatement selectStmt;
        AnnotatedCreateTableStatement.Column column;
        String castType;
        Intrinsics.checkNotNullParameter((Object)paramName, (String)"paramName");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement instanceof AnnotatedExecuteStatement) {
            ExecuteStatement execStmt = ((AnnotatedExecuteStatement)statement).getSrc();
            for (SelectStatement withSelectStatement : execStmt.getWithSelectStatements()) {
                Collection<AnnotatedSelectStatement.Field> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                if (!withSelectStatement.getNamedParameters().contains(paramName)) continue;
                Iterable iterable = withSelectStatement.getFields();
                StatementAnnotationOverrides statementAnnotationOverrides = new StatementAnnotationOverrides(null, ((AnnotatedExecuteStatement)statement).getAnnotations().getPropertyNameGenerator(), null, ((AnnotatedExecuteStatement)statement).getAnnotations().getImplements(), ((AnnotatedExecuteStatement)statement).getAnnotations().getExcludeOverrideFields(), null, false, null, null, 448, null);
                SelectStatement selectStatement = withSelectStatement;
                String string = "withClause";
                boolean $i$f$map = false;
                void var9_14 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void field;
                    SelectStatement.FieldSource fieldSource = (SelectStatement.FieldSource)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new AnnotatedSelectStatement.Field((SelectStatement.FieldSource)field, FieldAnnotationOverrides.Companion.parse(MapsKt.emptyMap()), null, 4, null));
                }
                Collection<AnnotatedSelectStatement.Field> collection2 = collection = (List)destination$iv$iv;
                StatementAnnotationOverrides statementAnnotationOverrides2 = statementAnnotationOverrides;
                SelectStatement selectStatement2 = selectStatement;
                String string2 = string;
                AnnotatedSelectStatement annotatedWithSelectStatement = new AnnotatedSelectStatement(string2, selectStatement2, statementAnnotationOverrides2, (List<AnnotatedSelectStatement.Field>)collection2);
                return this.inferParameterType(paramName, annotatedWithSelectStatement);
            }
        }
        if ((castType = this.getCastTypeForParameter(paramName, statement)) != null) {
            return SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(castType);
        }
        AssociatedColumn associatedColumn = this.getAssociatedColumn(statement, paramName);
        if (associatedColumn instanceof AssociatedColumn.Collection) {
            column = this.generatorContext.getColumnLookup().findColumnForParameter(statement, paramName);
            return this.handleCollectionParameterType(column);
        }
        if (statement instanceof AnnotatedSelectStatement && (Intrinsics.areEqual((Object)paramName, (Object)(selectStmt = ((AnnotatedSelectStatement)statement).getSrc()).getLimitNamedParam()) || Intrinsics.areEqual((Object)paramName, (Object)selectStmt.getOffsetNamedParam()))) {
            String[] annotatedWithSelectStatement = new String[]{"Long"};
            return (TypeName)new ClassName("kotlin", annotatedWithSelectStatement);
        }
        column = this.generatorContext.getColumnLookup().findColumnForParameter(statement, paramName);
        if (column != null) {
            TypeName baseType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(column.getSrc().getDataType());
            Object $i$f$map = column.getAnnotations().get("propertyType");
            String propertyType = $i$f$map instanceof String ? (String)$i$f$map : null;
            boolean isNullable = column.isNullable();
            return SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(baseType, propertyType, isNullable, this.fileGenerationHelper.getPackageName());
        }
        String[] stringArray = new String[]{"String"};
        return (TypeName)new ClassName("kotlin", stringArray);
    }

    private final String getCastTypeForParameter(String paramName, AnnotatedStatement statement) {
        AnnotatedStatement annotatedStatement = statement;
        return annotatedStatement instanceof AnnotatedSelectStatement ? ((AnnotatedSelectStatement)statement).getSrc().getParameterCastTypes().get(paramName) : (annotatedStatement instanceof AnnotatedExecuteStatement ? ((AnnotatedExecuteStatement)statement).getSrc().getParameterCastTypes().get(paramName) : null);
    }

    private final String getSqlFromStatement(AnnotatedStatement statement) {
        String string;
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            string = ((AnnotatedSelectStatement)statement).getSrc().getSql();
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            string = ((AnnotatedExecuteStatement)statement).getSrc().getSql();
        } else if (annotatedStatement instanceof AnnotatedCreateTableStatement) {
            string = ((AnnotatedCreateTableStatement)statement).getSrc().getSql();
        } else if (annotatedStatement instanceof AnnotatedCreateViewStatement) {
            string = ((AnnotatedCreateViewStatement)statement).getSrc().getSql();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getAffectedTablesFromStatement(AnnotatedStatement statement) {
        Set set;
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedSelectStatement) {
            void var3_3;
            Set tables = new LinkedHashSet();
            String string = ((AnnotatedSelectStatement)statement).getSrc().getFromTable();
            if (string != null) {
                String it = string;
                boolean bl = false;
                tables.add(it);
            }
            tables.addAll((Collection)((AnnotatedSelectStatement)statement).getSrc().getJoinTables());
            set = var3_3;
        } else if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            set = SetsKt.setOf((Object)((AnnotatedExecuteStatement)statement).getSrc().getTable());
        } else if (annotatedStatement instanceof AnnotatedCreateTableStatement) {
            set = SetsKt.setOf((Object)((AnnotatedCreateTableStatement)statement).getSrc().getTableName());
        } else if (annotatedStatement instanceof AnnotatedCreateViewStatement) {
            set = SetsKt.emptySet();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AssociatedColumn getAssociatedColumn(AnnotatedStatement statement, String paramName) {
        AssociatedColumn associatedColumn;
        AnnotatedStatement annotatedStatement = statement;
        if (annotatedStatement instanceof AnnotatedExecuteStatement) {
            ExecuteStatement src = ((AnnotatedExecuteStatement)statement).getSrc();
            if (src instanceof DeleteStatement) {
                associatedColumn = ((DeleteStatement)src).getNamedParametersToColumns().get(paramName);
                return associatedColumn;
            }
            if (src instanceof UpdateStatement) {
                associatedColumn = ((UpdateStatement)src).getNamedParametersToColumns().get(paramName);
                return associatedColumn;
            }
            if (!(src instanceof InsertStatement)) throw new NoWhenBranchMatchedException();
            return null;
        }
        if (!(annotatedStatement instanceof AnnotatedSelectStatement)) return null;
        associatedColumn = ((AnnotatedSelectStatement)statement).getSrc().getNamedParametersToColumns().get(paramName);
        return associatedColumn;
    }

    private final TypeName handleCollectionParameterType(AnnotatedCreateTableStatement.Column column) {
        if (column != null) {
            TypeName baseType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(column.getSrc().getDataType());
            Object object = column.getAnnotations().get("propertyType");
            String propertyType = object instanceof String ? (String)object : null;
            TypeName elementType = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType$default(SqliteTypeToKotlinCodeConverter.Companion, baseType, propertyType, column.isNullable(), null, 8, null);
            String[] stringArray = new String[]{"Collection"};
            ClassName className = new ClassName("kotlin.collections", stringArray);
            stringArray = new TypeName[]{elementType};
            return (TypeName)ParameterizedTypeName.Companion.get(className, (TypeName[])stringArray);
        }
        String[] stringArray = new String[]{"Collection"};
        ClassName className = new ClassName("kotlin.collections", stringArray);
        stringArray = new TypeName[1];
        String[] stringArray2 = new String[]{"String"};
        stringArray[0] = new ClassName("kotlin", stringArray2);
        return (TypeName)ParameterizedTypeName.Companion.get(className, (TypeName[])stringArray);
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$0(DataStructCodeGenerator this$0, String $namespace, Map $sharedResultsWithContext, TypeSpec.Builder $namespaceObject, AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.sharedResultManager.registerSharedResult(statement, $namespace);
        if (statement.getAnnotations().getQueryResult() != null) {
            $sharedResultsWithContext.put(statement.getAnnotations().getQueryResult(), statement);
        }
        TypeSpec queryObject = this$0.generateQueryObject(statement);
        $namespaceObject.addType(queryObject);
        return Unit.INSTANCE;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$1(DataStructCodeGenerator this$0, TypeSpec.Builder $namespaceObject, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        TypeSpec queryObject = this$0.generateQueryObject(statement);
        $namespaceObject.addType(queryObject);
        return Unit.INSTANCE;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$2(DataStructCodeGenerator this$0, String $namespace, String $packageName, AnnotatedSelectStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this$0.resultFileEmitter.writeSelectResultFile(statement, $namespace, $packageName);
        if (statement.hasDynamicFieldMapping()) {
            this$0.resultFileEmitter.writeJoinedClassFile(statement, $namespace, $packageName);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateNamespaceDataStructuresCode$lambda$3(DataStructCodeGenerator this$0, String $namespace, String $packageName, AnnotatedExecuteStatement statement) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        if (statement.hasReturningClause()) {
            this$0.resultFileEmitter.writeExecuteResultFile(statement, $namespace, $packageName);
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence generateQueryObject$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }

    private static final FileSpec.Builder generateCode$lambda$0(DataStructCodeGenerator this$0, String namespace, String packageName) {
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return this$0.generateNamespaceDataStructuresCode(namespace, packageName);
    }
}

