/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.sqlinspect.SelectStatement;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u000bJ\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\nH\u0002J(\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u001e\u0010 \u001a\u0004\u0018\u00010\r2\b\u0010!\u001a\u0004\u0018\u00010\r2\b\u0010\"\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010#\u001a\u0004\u0018\u00010\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\r2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver;", "", "createTableStatements", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "<init>", "(Ljava/util/List;Ljava/util/List;)V", "viewLookup", "", "", "resolvedAnnotations", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;", "annotationCache", "", "getFieldAnnotations", "tableName", "fieldName", "findView", "viewName", "buildResolvedAnnotations", "resolveAnnotation", "visited", "", "findViewField", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement$Field;", "view", "hasAnyAnnotations", "", "annotations", "hasPropertyType", "mergeAnnotations", "primary", "secondary", "augmentWithFieldSource", "fieldSource", "Ldev/goquick/sqlitenow/gradle/sqlinspect/SelectStatement$FieldSource;", "canonicalKey", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nFieldAnnotationResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FieldAnnotationResolver.kt\ndev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1202#2,2:199\n1230#2,4:201\n1863#2:206\n1863#2,2:207\n1864#2:209\n1863#2:210\n1863#2,2:211\n1864#2:213\n1863#2,2:214\n295#2,2:216\n1#3:205\n*S KotlinDebug\n*F\n+ 1 FieldAnnotationResolver.kt\ndev/goquick/sqlitenow/gradle/processing/FieldAnnotationResolver\n*L\n17#1:199,2\n17#1:201,4\n56#1:206\n57#1:207,2\n56#1:209\n67#1:210\n68#1:211,2\n67#1:213\n110#1:214,2\n129#1:216,2\n*E\n"})
public final class FieldAnnotationResolver {
    @NotNull
    private final List<AnnotatedCreateTableStatement> createTableStatements;
    @NotNull
    private final List<AnnotatedCreateViewStatement> createViewStatements;
    @NotNull
    private final Map<String, AnnotatedCreateViewStatement> viewLookup;
    @NotNull
    private final Map<String, FieldAnnotationOverrides> resolvedAnnotations;
    @NotNull
    private final Map<String, FieldAnnotationOverrides> annotationCache;

    /*
     * WARNING - void declaration
     */
    public FieldAnnotationResolver(@NotNull List<AnnotatedCreateTableStatement> createTableStatements, @NotNull List<AnnotatedCreateViewStatement> createViewStatements) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        Intrinsics.checkNotNullParameter(createViewStatements, (String)"createViewStatements");
        this.createTableStatements = createTableStatements;
        this.createViewStatements = createViewStatements;
        Iterable iterable = this.createViewStatements;
        FieldAnnotationResolver fieldAnnotationResolver = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var6_7 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            AnnotatedCreateViewStatement annotatedCreateViewStatement = (AnnotatedCreateViewStatement)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it.getSrc().getViewName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map.put(string, element$iv$iv);
        }
        fieldAnnotationResolver.viewLookup = destination$iv$iv;
        this.annotationCache = new LinkedHashMap();
        this.resolvedAnnotations = this.buildResolvedAnnotations();
    }

    @Nullable
    public final FieldAnnotationOverrides getFieldAnnotations(@NotNull String tableName, @NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        String key = this.canonicalKey(tableName, fieldName);
        FieldAnnotationOverrides fieldAnnotationOverrides = this.annotationCache.get(key);
        if (fieldAnnotationOverrides != null) {
            FieldAnnotationOverrides it = fieldAnnotationOverrides;
            boolean bl = false;
            return it;
        }
        FieldAnnotationOverrides resolved = this.resolveAnnotation(tableName, fieldName, new LinkedHashSet());
        this.annotationCache.put(key, resolved);
        return resolved;
    }

    @Nullable
    public final AnnotatedCreateViewStatement findView(@NotNull String viewName) {
        Intrinsics.checkNotNullParameter((Object)viewName, (String)"viewName");
        String string = viewName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return this.viewLookup.get(string);
    }

    private final Map<String, FieldAnnotationOverrides> buildResolvedAnnotations() {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Map annotations = new LinkedHashMap();
        Iterable $this$forEach$iv2 = this.createTableStatements;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            AnnotatedCreateTableStatement table = (AnnotatedCreateTableStatement)element$iv;
            boolean bl = false;
            $this$forEach$iv = table.getColumns();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                AnnotatedCreateTableStatement.Column column = (AnnotatedCreateTableStatement.Column)element$iv2;
                boolean bl2 = false;
                FieldAnnotationOverrides fieldAnnotations = FieldAnnotationOverrides.Companion.parse(column.getAnnotations());
                if (!this.hasAnyAnnotations(fieldAnnotations)) continue;
                String key = this.canonicalKey(table.getName(), column.getSrc().getName());
                annotations.put(key, fieldAnnotations);
            }
        }
        $this$forEach$iv2 = this.createViewStatements;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            AnnotatedCreateViewStatement view = (AnnotatedCreateViewStatement)element$iv;
            boolean bl = false;
            $this$forEach$iv = view.getFields();
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                AnnotatedCreateViewStatement.Field field = (AnnotatedCreateViewStatement.Field)element$iv2;
                boolean bl3 = false;
                if (!this.hasAnyAnnotations(field.getAnnotations())) continue;
                String key = this.canonicalKey(view.getSrc().getViewName(), field.getSrc().getFieldName());
                annotations.put(key, field.getAnnotations());
            }
        }
        return annotations;
    }

    private final FieldAnnotationOverrides resolveAnnotation(String tableName, String fieldName, Set<String> visited) {
        FieldAnnotationOverrides fieldAnnotationOverrides;
        String sourceAlias;
        Iterator<Object> iterator;
        FieldAnnotationOverrides resolved;
        AnnotatedCreateViewStatement.Field viewField;
        AnnotatedCreateViewStatement view;
        FieldAnnotationOverrides direct;
        block11: {
            block10: {
                Iterator iterator2;
                String key = this.canonicalKey(tableName, fieldName);
                if (!visited.add(key)) {
                    return this.resolvedAnnotations.get(key);
                }
                direct = this.resolvedAnnotations.get(key);
                String string = tableName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                AnnotatedCreateViewStatement annotatedCreateViewStatement = this.viewLookup.get(string);
                if (annotatedCreateViewStatement == null) {
                    return direct;
                }
                view = annotatedCreateViewStatement;
                viewField = this.findViewField(view, fieldName);
                resolved = null;
                resolved = viewField != null && this.hasAnyAnnotations(viewField.getAnnotations()) ? viewField.getAnnotations() : null;
                iterator = viewField;
                if (iterator == null || (iterator = ((AnnotatedCreateViewStatement.Field)((Object)iterator)).getSrc()) == null || (iterator = ((SelectStatement.FieldSource)((Object)iterator)).getOriginalColumnName()) == null) break block10;
                Iterator it = iterator2 = iterator;
                boolean bl = false;
                iterator = !StringsKt.isBlank((CharSequence)((CharSequence)((Object)it))) ? iterator2 : null;
                if (iterator != null) break block11;
            }
            iterator = fieldName;
        }
        Iterator downstreamFieldName = iterator;
        Map<String, String> tableAliases = view.getSrc().getSelectStatement().getTableAliases();
        if (viewField != null && !StringsKt.isBlank((CharSequence)(sourceAlias = viewField.getSrc().getTableName()))) {
            String string = tableAliases.get(sourceAlias);
            if (string == null) {
                string = sourceAlias;
            }
            String target = string;
            FieldAnnotationOverrides aliasResolved = this.resolveAnnotation(target, (String)((Object)downstreamFieldName), visited);
            resolved = this.mergeAnnotations(resolved, aliasResolved);
        }
        if (resolved == null || !this.hasPropertyType(resolved)) {
            Iterable $this$forEach$iv = tableAliases.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String target = (String)element$iv;
                boolean bl = false;
                FieldAnnotationOverrides nestedResolved = this.resolveAnnotation(target, (String)((Object)downstreamFieldName), visited);
                resolved = this.mergeAnnotations(resolved, nestedResolved);
            }
        }
        if ((fieldAnnotationOverrides = this.mergeAnnotations(resolved, direct)) == null && (fieldAnnotationOverrides = direct) == null) {
            AnnotatedCreateViewStatement.Field field = viewField;
            fieldAnnotationOverrides = field != null ? field.getAnnotations() : null;
        }
        FieldAnnotationOverrides merged = fieldAnnotationOverrides;
        return viewField != null ? this.augmentWithFieldSource(merged, viewField.getSrc()) : merged;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final AnnotatedCreateViewStatement.Field findViewField(AnnotatedCreateViewStatement view, String fieldName) {
        Object element$iv;
        Object v1;
        boolean bl;
        String string = fieldName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String normalized = string;
        Iterable $this$firstOrNull$iv = view.getFields();
        boolean $i$f$firstOrNull = false;
        Iterator iterator = $this$firstOrNull$iv.iterator();
        do {
            block6: {
                block5: {
                    if (!iterator.hasNext()) {
                        v1 = null;
                        return v1;
                    }
                    element$iv = iterator.next();
                    AnnotatedCreateViewStatement.Field field = (AnnotatedCreateViewStatement.Field)element$iv;
                    boolean bl2 = false;
                    if (StringsKt.equals((String)field.getSrc().getFieldName(), (String)fieldName, (boolean)true) || StringsKt.equals((String)field.getSrc().getOriginalColumnName(), (String)fieldName, (boolean)true)) break block5;
                    String string2 = field.getSrc().getFieldName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                    if (Intrinsics.areEqual((Object)string2, (Object)normalized)) break block5;
                    String string3 = field.getSrc().getOriginalColumnName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                    if (!Intrinsics.areEqual((Object)string3, (Object)normalized)) break block6;
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (!bl);
        v1 = element$iv;
        return v1;
    }

    private final boolean hasAnyAnnotations(FieldAnnotationOverrides annotations) {
        return annotations.getPropertyName() != null || annotations.getPropertyType() != null || Intrinsics.areEqual((Object)annotations.getAdapter(), (Object)true) || annotations.getNotNull() != null || annotations.getSqlTypeHint() != null || annotations.isDynamicField() || annotations.getDefaultValue() != null || annotations.getAliasPrefix() != null || annotations.getMappingType() != null || annotations.getSourceTable() != null || annotations.getSuppressProperty();
    }

    private final boolean hasPropertyType(FieldAnnotationOverrides annotations) {
        return annotations.getPropertyType() != null;
    }

    private final FieldAnnotationOverrides mergeAnnotations(FieldAnnotationOverrides primary, FieldAnnotationOverrides secondary) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        Boolean bl;
        Boolean bl2;
        String string6;
        if (primary == null) {
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        String string7 = primary.getPropertyName();
        if (string7 == null) {
            string7 = secondary.getPropertyName();
        }
        if ((string6 = primary.getPropertyType()) == null) {
            string6 = secondary.getPropertyType();
        }
        if ((bl2 = primary.getNotNull()) == null) {
            bl2 = secondary.getNotNull();
        }
        if ((bl = primary.getAdapter()) == null) {
            bl = secondary.getAdapter();
        }
        boolean bl3 = primary.isDynamicField() || secondary.isDynamicField();
        String string8 = primary.getDefaultValue();
        if (string8 == null) {
            string8 = secondary.getDefaultValue();
        }
        if ((string5 = primary.getAliasPrefix()) == null) {
            string5 = secondary.getAliasPrefix();
        }
        if ((string4 = primary.getMappingType()) == null) {
            string4 = secondary.getMappingType();
        }
        if ((string3 = primary.getSourceTable()) == null) {
            string3 = secondary.getSourceTable();
        }
        if ((string2 = primary.getCollectionKey()) == null) {
            string2 = secondary.getCollectionKey();
        }
        if ((string = primary.getSqlTypeHint()) == null) {
            string = secondary.getSqlTypeHint();
        }
        return new FieldAnnotationOverrides(string7, string6, bl2, bl, bl3, string8, string5, string4, string3, string2, string, primary.getSuppressProperty() || secondary.getSuppressProperty());
    }

    private final FieldAnnotationOverrides augmentWithFieldSource(FieldAnnotationOverrides annotations, SelectStatement.FieldSource fieldSource) {
        if (annotations == null || annotations.getPropertyType() != null) {
            return annotations;
        }
        if (!this.hasAnyAnnotations(annotations)) {
            return annotations;
        }
        String computedType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(fieldSource.getDataType()).toString();
        return FieldAnnotationOverrides.copy$default(annotations, null, computedType, null, null, false, null, null, null, null, null, null, false, 4093, null);
    }

    private final String canonicalKey(String tableName, String fieldName) {
        String string = ((Object)StringsKt.trim((CharSequence)tableName)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = ((Object)StringsKt.trim((CharSequence)fieldName)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string + "." + string2;
    }
}

