/*
 * Decompiled with CFR 0.152.
 */
package dev.goquick.sqlitenow.gradle.processing;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateTableStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedCreateViewStatement;
import dev.goquick.sqlitenow.gradle.model.AnnotatedSelectStatement;
import dev.goquick.sqlitenow.gradle.processing.FieldAnnotationOverrides;
import dev.goquick.sqlitenow.gradle.processing.PropertyNameGeneratorType;
import dev.goquick.sqlitenow.gradle.sqlinspect.SelectStatement;
import dev.goquick.sqlitenow.gradle.util.CaseInsensitiveMap;
import dev.goquick.sqlitenow.gradle.util.CaseInsensitiveSet;
import dev.goquick.sqlitenow.gradle.util.SqliteTypeToKotlinCodeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B3\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\b2\u0006\u0010%\u001a\u00020&H\u0002J\u0017\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a2\u0006\u0002\u0010*J \u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010/\u001a\u00020)2\u0006\u0010\u0017\u001a\u00020\u0018J@\u00100\u001a\u0004\u0018\u00010 2\u0006\u00101\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0016\u00102\u001a\u0012\u0012\u0004\u0012\u00020\b03j\b\u0012\u0004\u0012\u00020\b`42\n\b\u0002\u00105\u001a\u0004\u0018\u00010\bH\u0002J1\u00106\u001a\u0012\u0012\u0004\u0012\u00020\b03j\b\u0012\u0004\u0012\u00020\b`42\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b08\"\u00020\bH\u0002\u00a2\u0006\u0002\u00109J\u001e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0>H\u0002J \u0010?\u001a\u0012\u0012\u0004\u0012\u00020\b03j\b\u0012\u0004\u0012\u00020\b`42\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J1\u0010@\u001a\u0012\u0012\u0004\u0012\u00020\b03j\b\u0012\u0004\u0012\u00020\b`42\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b08\"\u00020\bH\u0002\u00a2\u0006\u0002\u00109J\u0012\u0010A\u001a\u0004\u0018\u00010\u00062\u0006\u0010<\u001a\u00020\bH\u0002J.\u0010B\u001a\u0004\u0018\u00010C2\u0006\u0010D\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010E\u001a\u0004\u0018\u00010\b2\b\u0010F\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010G\u001a\u0004\u0018\u00010\b*\u00020\b2\u0006\u0010H\u001a\u00020\bH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Ldev/goquick/sqlitenow/gradle/processing/SelectFieldCodeGenerator;", "", "createTableStatements", "", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement;", "createViewStatements", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement;", "packageName", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "tableMap", "", "viewMap", "Ldev/goquick/sqlitenow/gradle/util/CaseInsensitiveMap;", "viewAliasMap", "kotlinStringType", "Lcom/squareup/kotlinpoet/ClassName;", "kotlinLongType", "kotlinDoubleType", "generateFieldInfo", "Lkotlin/Pair;", "Lcom/squareup/kotlinpoet/TypeName;", "field", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement$Field;", "propertyNameGeneratorType", "Ldev/goquick/sqlitenow/gradle/processing/PropertyNameGeneratorType;", "generateProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "generateParameter", "Lcom/squareup/kotlinpoet/ParameterSpec;", "findColumnForField", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateTableStatement$Column;", "mapSqlTypeToKotlinType", "sqliteType", "inferAggregateType", "inferFunctionType", "function", "Lnet/sf/jsqlparser/expression/Function;", "extractFunctionName", "inferAggregateNullability", "", "(Ldev/goquick/sqlitenow/gradle/model/AnnotatedSelectStatement$Field;)Ljava/lang/Boolean;", "generatePropertyName", "fieldName", "annotations", "Ldev/goquick/sqlitenow/gradle/processing/FieldAnnotationOverrides;", "determineNullability", "lookupColumnUsingCandidates", "table", "candidates", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "preferredName", "buildColumnNameCandidates", "names", "", "([Ljava/lang/String;)Ljava/util/LinkedHashSet;", "addNameVariants", "", "name", "sink", "", "buildNameCandidatesFromAliasPrefix", "buildNameCandidates", "findViewByName", "findMatchingViewField", "Ldev/goquick/sqlitenow/gradle/model/AnnotatedCreateViewStatement$Field;", "view", "aliasPrefix", "sourceAlias", "removePrefixOrNull", "prefix", "sqlitenow-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSelectFieldCodeGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectFieldCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/processing/SelectFieldCodeGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,450:1\n1202#2,2:451\n1230#2,4:453\n1557#2:457\n1628#2,3:458\n1557#2:461\n1628#2,3:462\n1863#2,2:466\n1863#2,2:468\n1863#2,2:470\n295#2,2:472\n295#2,2:474\n774#2:478\n865#2,2:479\n1863#2,2:481\n1863#2,2:483\n295#2,2:485\n1#3:465\n13409#4,2:476\n*S KotlinDebug\n*F\n+ 1 SelectFieldCodeGenerator.kt\ndev/goquick/sqlitenow/gradle/processing/SelectFieldCodeGenerator\n*L\n32#1:451,2\n32#1:453,4\n33#1:457\n33#1:458,3\n34#1:461\n34#1:462,3\n183#1:466,2\n187#1:468,2\n357#1:470,2\n362#1:472,2\n368#1:474,2\n396#1:478\n396#1:479,2\n398#1:481,2\n412#1:483,2\n432#1:485,2\n378#1:476,2\n*E\n"})
public final class SelectFieldCodeGenerator {
    @NotNull
    private final List<AnnotatedCreateViewStatement> createViewStatements;
    @Nullable
    private final String packageName;
    @NotNull
    private final Map<String, AnnotatedCreateTableStatement> tableMap;
    @NotNull
    private final CaseInsensitiveMap<AnnotatedCreateViewStatement> viewMap;
    @NotNull
    private final CaseInsensitiveMap<AnnotatedCreateViewStatement> viewAliasMap;
    @NotNull
    private final ClassName kotlinStringType;
    @NotNull
    private final ClassName kotlinLongType;
    @NotNull
    private final ClassName kotlinDoubleType;

    /*
     * WARNING - void declaration
     */
    public SelectFieldCodeGenerator(@NotNull List<AnnotatedCreateTableStatement> createTableStatements, @NotNull List<AnnotatedCreateViewStatement> createViewStatements, @Nullable String packageName) {
        AnnotatedCreateViewStatement it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(createTableStatements, (String)"createTableStatements");
        Intrinsics.checkNotNullParameter(createViewStatements, (String)"createViewStatements");
        this.createViewStatements = createViewStatements;
        this.packageName = packageName;
        String[] stringArray = (String[])createTableStatements;
        SelectFieldCodeGenerator selectFieldCodeGenerator = this;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            AnnotatedCreateTableStatement annotatedCreateTableStatement = (AnnotatedCreateTableStatement)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            String string = it2.getSrc().getTableName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map.put(string, element$iv$iv);
        }
        selectFieldCodeGenerator.tableMap = destination$iv$iv;
        $this$associateBy$iv = this.createViewStatements;
        selectFieldCodeGenerator = this;
        boolean $i$f$map = false;
        void capacity$iv22 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv$iv;
            element$iv$iv = (AnnotatedCreateViewStatement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getSrc().getViewName(), (Object)it));
        }
        Iterable iterable = (List)destination$iv$iv2;
        selectFieldCodeGenerator.viewMap = new CaseInsensitiveMap(iterable);
        $this$map$iv = this.createViewStatements;
        selectFieldCodeGenerator = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AnnotatedCreateViewStatement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it.getName(), (Object)it));
        }
        Iterable iterable2 = (List)destination$iv$iv2;
        selectFieldCodeGenerator.viewAliasMap = new CaseInsensitiveMap(iterable2);
        stringArray = new String[]{"String"};
        this.kotlinStringType = new ClassName("kotlin", stringArray);
        stringArray = new String[]{"Long"};
        this.kotlinLongType = new ClassName("kotlin", stringArray);
        stringArray = new String[]{"Double"};
        this.kotlinDoubleType = new ClassName("kotlin", stringArray);
    }

    public /* synthetic */ SelectFieldCodeGenerator(List list, List list2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            string = null;
        }
        this(list, list2, string);
    }

    private final Pair<String, TypeName> generateFieldInfo(AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGeneratorType) {
        block9: {
            String string;
            String propertyName;
            block11: {
                block10: {
                    boolean bl;
                    if (!field.getAnnotations().isDynamicField()) break block9;
                    propertyName = this.generatePropertyName(field.getSrc().getFieldName(), field.getAnnotations(), propertyNameGeneratorType);
                    Boolean bl2 = field.getAnnotations().getNotNull();
                    if (Intrinsics.areEqual((Object)bl2, (Object)true)) {
                        bl = false;
                    } else if (Intrinsics.areEqual((Object)bl2, (Object)false)) {
                        bl = true;
                    } else if (bl2 == null) {
                        bl = field.getAnnotations().getMappingType() != null;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    boolean isNullable = bl;
                    string = field.getAnnotations().getPropertyType();
                    if (string == null) break block10;
                    String it = string;
                    boolean bl3 = false;
                    String[] stringArray = new String[]{"String"};
                    TypeName typeName = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType((TypeName)new ClassName("kotlin", stringArray), it, isNullable, this.packageName);
                    string = typeName;
                    if (typeName != null) break block11;
                }
                throw new IllegalStateException("Dynamic field must have propertyType annotation");
            }
            String propertyType = string;
            return new Pair((Object)propertyName, (Object)propertyType);
        }
        String fieldName = field.getSrc().getFieldName();
        String propertyName = this.generatePropertyName(fieldName, field.getAnnotations(), propertyNameGeneratorType);
        TypeName baseType = this.mapSqlTypeToKotlinType(field.getSrc().getDataType(), field);
        boolean isNullable = this.determineNullability(field);
        TypeName propertyType = SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(baseType, field.getAnnotations().getPropertyType(), isNullable, this.packageName);
        return new Pair((Object)propertyName, (Object)propertyType);
    }

    @NotNull
    public final PropertySpec generateProperty(@NotNull AnnotatedSelectStatement.Field field, @NotNull PropertyNameGeneratorType propertyNameGeneratorType) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGeneratorType), (String)"propertyNameGeneratorType");
        Pair<String, TypeName> pair = this.generateFieldInfo(field, propertyNameGeneratorType);
        String propertyName = (String)pair.component1();
        TypeName propertyType = (TypeName)pair.component2();
        return PropertySpec.Companion.builder(propertyName, propertyType, new KModifier[0]).initializer(propertyName, new Object[0]).build();
    }

    public static /* synthetic */ PropertySpec generateProperty$default(SelectFieldCodeGenerator selectFieldCodeGenerator, AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGeneratorType, int n, Object object) {
        if ((n & 2) != 0) {
            propertyNameGeneratorType = PropertyNameGeneratorType.LOWER_CAMEL_CASE;
        }
        return selectFieldCodeGenerator.generateProperty(field, propertyNameGeneratorType);
    }

    @NotNull
    public final ParameterSpec generateParameter(@NotNull AnnotatedSelectStatement.Field field, @NotNull PropertyNameGeneratorType propertyNameGeneratorType) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)((Object)propertyNameGeneratorType), (String)"propertyNameGeneratorType");
        Pair<String, TypeName> pair = this.generateFieldInfo(field, propertyNameGeneratorType);
        String propertyName = (String)pair.component1();
        TypeName propertyType = (TypeName)pair.component2();
        ParameterSpec.Builder parameterBuilder = ParameterSpec.Companion.builder(propertyName, propertyType, new KModifier[0]);
        if (field.getAnnotations().isDynamicField() && field.getAnnotations().getDefaultValue() != null) {
            parameterBuilder.defaultValue(field.getAnnotations().getDefaultValue(), new Object[0]);
        }
        return parameterBuilder.build();
    }

    public static /* synthetic */ ParameterSpec generateParameter$default(SelectFieldCodeGenerator selectFieldCodeGenerator, AnnotatedSelectStatement.Field field, PropertyNameGeneratorType propertyNameGeneratorType, int n, Object object) {
        if ((n & 2) != 0) {
            propertyNameGeneratorType = PropertyNameGeneratorType.LOWER_CAMEL_CASE;
        }
        return selectFieldCodeGenerator.generateParameter(field, propertyNameGeneratorType);
    }

    private final AnnotatedCreateTableStatement.Column findColumnForField(AnnotatedSelectStatement.Field field) {
        LinkedHashSet<String> viewCandidates;
        Object object;
        AnnotatedCreateViewStatement.Field viewField;
        AnnotatedCreateViewStatement view;
        AnnotatedCreateTableStatement table;
        String string;
        String aliasPrefix = field.getAnnotations().getAliasPrefix();
        String sourceAlias = field.getAnnotations().getSourceTable();
        LinkedHashSet<String> candidates = this.buildNameCandidatesFromAliasPrefix(field);
        String it = string = field.getSrc().getTableName();
        boolean bl = false;
        String string2 = !StringsKt.isBlank((CharSequence)it) ? string : null;
        if (string2 != null) {
            String tableName = string2;
            boolean bl2 = false;
            String string3 = tableName.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            AnnotatedCreateTableStatement annotatedCreateTableStatement = this.tableMap.get(string3);
            if (annotatedCreateTableStatement != null) {
                table = annotatedCreateTableStatement;
                boolean bl3 = false;
                AnnotatedCreateTableStatement.Column column = SelectFieldCodeGenerator.lookupColumnUsingCandidates$default(this, table, field, candidates, null, 8, null);
                if (column != null) {
                    AnnotatedCreateTableStatement.Column it2 = column;
                    boolean bl4 = false;
                    return it2;
                }
            }
            AnnotatedCreateViewStatement annotatedCreateViewStatement = this.findViewByName(tableName);
            if (annotatedCreateViewStatement != null) {
                view = annotatedCreateViewStatement;
                boolean bl5 = false;
                viewField = this.findMatchingViewField(view, field, aliasPrefix, sourceAlias);
                if (viewField != null) {
                    String string4 = viewField.getSrc().getTableName().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    AnnotatedCreateTableStatement annotatedCreateTableStatement2 = this.tableMap.get(string4);
                    if (annotatedCreateTableStatement2 != null) {
                        AnnotatedCreateTableStatement underlying = annotatedCreateTableStatement2;
                        boolean bl6 = false;
                        object = new String[]{viewField.getSrc().getOriginalColumnName(), field.getSrc().getFieldName(), viewField.getSrc().getOriginalColumnName()};
                        viewCandidates = this.buildNameCandidates((String)object);
                        if ((object = this.lookupColumnUsingCandidates(underlying, field, viewCandidates, viewField.getSrc().getOriginalColumnName())) != null) {
                            String[] it3 = object;
                            boolean bl7 = false;
                            return it3;
                        }
                    }
                }
            }
        }
        Iterable $this$forEach$iv = this.tableMap.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            table = (AnnotatedCreateTableStatement)element$iv;
            boolean bl8 = false;
            AnnotatedCreateTableStatement.Column column = SelectFieldCodeGenerator.lookupColumnUsingCandidates$default(this, table, field, candidates, null, 8, null);
            if (column == null) continue;
            AnnotatedCreateTableStatement.Column it4 = column;
            boolean bl9 = false;
            return it4;
        }
        $this$forEach$iv = this.createViewStatements;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnnotatedCreateTableStatement table2;
            view = (AnnotatedCreateViewStatement)element$iv;
            boolean bl10 = false;
            viewField = this.findMatchingViewField(view, field, aliasPrefix, sourceAlias);
            if (viewField == null) continue;
            String string5 = viewField.getSrc().getTableName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            if (this.tableMap.get(string5) == null) continue;
            boolean bl11 = false;
            object = new String[]{viewField.getSrc().getOriginalColumnName(), field.getSrc().getFieldName(), viewField.getSrc().getOriginalColumnName()};
            viewCandidates = this.buildNameCandidates((String)object);
            if ((object = this.lookupColumnUsingCandidates(table2, field, viewCandidates, viewField.getSrc().getOriginalColumnName())) == null) continue;
            Object it5 = object;
            boolean bl12 = false;
            return it5;
        }
        return null;
    }

    private final TypeName mapSqlTypeToKotlinType(String sqliteType, AnnotatedSelectStatement.Field field) {
        AnnotatedCreateTableStatement.Column column;
        TypeName typeName = this.inferAggregateType(field);
        if (typeName != null) {
            TypeName it = typeName;
            boolean bl = false;
            return it;
        }
        String[] stringArray = new String[]{"("};
        String string = ((String)StringsKt.split$default((CharSequence)sqliteType, (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)).toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String baseType = string;
        TypeName kotlinType = SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(baseType);
        if (field != null && (column = this.findColumnForField(field)) != null) {
            String propertyType;
            Object object = column.getAnnotations().get("propertyType");
            String string2 = propertyType = object instanceof String ? (String)object : null;
            if (propertyType != null) {
                return SqliteTypeToKotlinCodeConverter.Companion.determinePropertyType(kotlinType, propertyType, false, this.packageName);
            }
            String string3 = column.getSrc().getDataType().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            String columnType = string3;
            return SqliteTypeToKotlinCodeConverter.Companion.mapSqlTypeToKotlinType(columnType);
        }
        return kotlinType;
    }

    static /* synthetic */ TypeName mapSqlTypeToKotlinType$default(SelectFieldCodeGenerator selectFieldCodeGenerator, String string, AnnotatedSelectStatement.Field field, int n, Object object) {
        if ((n & 2) != 0) {
            field = null;
        }
        return selectFieldCodeGenerator.mapSqlTypeToKotlinType(string, field);
    }

    private final TypeName inferAggregateType(AnnotatedSelectStatement.Field field) {
        Object object = field;
        if (object == null || (object = ((AnnotatedSelectStatement.Field)object).getSrc()) == null || (object = ((SelectStatement.FieldSource)object).getExpression()) == null) {
            return null;
        }
        Object expression = object;
        Object object2 = expression;
        return object2 instanceof MySQLGroupConcat ? (TypeName)this.kotlinStringType : (object2 instanceof Function ? this.inferFunctionType((Function)expression) : null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final TypeName inferFunctionType(Function function) {
        String string = this.extractFunctionName(function);
        if (string == null) return null;
        int n = -1;
        switch (string.hashCode()) {
            case 80012068: {
                if (string.equals("TOTAL")) {
                    n = 1;
                }
                break;
            }
            case 65202: {
                if (string.equals("AVG")) {
                    n = 1;
                }
                break;
            }
            case -2009694334: {
                if (string.equals("JSON_GROUP_ARRAY")) {
                    n = 2;
                }
                break;
            }
            case 64313583: {
                if (string.equals("COUNT")) {
                    n = 3;
                }
                break;
            }
            case 82475: {
                if (string.equals("SUM")) {
                    n = 1;
                }
                break;
            }
            case -155354736: {
                if (string.equals("COUNT_BIG")) {
                    n = 3;
                }
                break;
            }
            case -7778060: {
                if (string.equals("GROUP_CONCAT")) {
                    n = 4;
                }
                break;
            }
            case -1785185514: {
                if (string.equals("JSON_GROUP_OBJECT")) {
                    n = 2;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                TypeName typeName = (TypeName)this.kotlinLongType;
                return typeName;
            }
            case 4: {
                TypeName typeName = (TypeName)this.kotlinStringType;
                return typeName;
            }
            case 1: {
                TypeName typeName = (TypeName)this.kotlinDoubleType;
                return typeName;
            }
            case 2: {
                TypeName typeName = (TypeName)this.kotlinStringType;
                return typeName;
            }
            default: {
                return null;
            }
        }
    }

    private final String extractFunctionName(Function function) {
        String string;
        String prefix;
        String string2;
        char ch;
        StringBuilder stringBuilder;
        String string3;
        String string4 = function.getName();
        if (string4 != null) {
            String string5;
            String it = string5 = string4;
            boolean bl = false;
            string3 = !StringsKt.isBlank((CharSequence)it) ? string5 : null;
        } else {
            string3 = null;
        }
        String explicitName = string3;
        CharSequence charSequence = explicitName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            charSequence = explicitName;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string6 = ((String)charSequence).toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toUpperCase(...)");
            return string6;
        }
        String string7 = function.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toString(...)");
        String raw = string7;
        StringBuilder $this$extractFunctionName_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        int n = raw.length();
        for (int i = 0; i < n && (Character.isLetterOrDigit(ch = raw.charAt(i)) || ch == '_'); ++i) {
            $this$extractFunctionName_u24lambda_u241.append(ch);
        }
        String string8 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toString(...)");
        String it = string2 = (prefix = string8);
        boolean bl2 = false;
        String string9 = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        if (string9 != null) {
            string2 = string9;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            String string10 = string2.toUpperCase(locale);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toUpperCase(...)");
        } else {
            string = null;
        }
        return string;
    }

    private final Boolean inferAggregateNullability(AnnotatedSelectStatement.Field field) {
        Expression expression = field.getSrc().getExpression();
        if (expression == null) {
            return null;
        }
        Expression expression2 = expression;
        if (!(expression2 instanceof Function)) {
            return null;
        }
        Function function = (Function)expression2;
        String string = this.extractFunctionName(function);
        return Intrinsics.areEqual((Object)string, (Object)"COUNT") || Intrinsics.areEqual((Object)string, (Object)"COUNT_BIG") ? Boolean.valueOf(false) : null;
    }

    private final String generatePropertyName(String fieldName, FieldAnnotationOverrides annotations, PropertyNameGeneratorType propertyNameGeneratorType) {
        String string = annotations.getPropertyName();
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        return propertyNameGeneratorType.convertToPropertyName(fieldName);
    }

    public final boolean determineNullability(@NotNull AnnotatedSelectStatement.Field field) {
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Boolean bl = field.getAnnotations().getNotNull();
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            return true;
        }
        if (bl == null) {
            AnnotatedCreateTableStatement.Column column = this.findColumnForField(field);
            if (column != null) {
                return column.isNullable();
            }
            Boolean bl2 = this.inferAggregateNullability(field);
            if (bl2 != null) {
                boolean it = bl2;
                boolean bl3 = false;
                return it;
            }
            return true;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final AnnotatedCreateTableStatement.Column lookupColumnUsingCandidates(AnnotatedCreateTableStatement table, AnnotatedSelectStatement.Field field, LinkedHashSet<String> candidates, String preferredName) {
        Object v2;
        Object object;
        block9: {
            LinkedHashSet searchOrder = new LinkedHashSet();
            String string = preferredName;
            if (string != null) {
                String string2 = string;
                Object it = string2;
                boolean bl = false;
                string = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? string2 : null;
                if (string != null) {
                    it = string;
                    boolean bl2 = false;
                    ((Collection)searchOrder).add(it);
                }
            }
            CollectionsKt.addAll((Collection)searchOrder, (Iterable)candidates);
            Iterable $this$forEach$iv = searchOrder;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String candidate = (String)element$iv;
                boolean bl = false;
                AnnotatedCreateTableStatement.Column column = table.findColumnByName(candidate);
                if (column == null) continue;
                AnnotatedCreateTableStatement.Column it = column;
                boolean bl3 = false;
                return it;
            }
            object = new CaseInsensitiveSet();
            CaseInsensitiveSet $this$lookupColumnUsingCandidates_u24lambda_u243 = object;
            boolean bl = false;
            $this$lookupColumnUsingCandidates_u24lambda_u243.addAll(searchOrder);
            CaseInsensitiveSet caseInsensitive = object;
            Iterable $this$firstOrNull$iv = table.getColumns();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotatedCreateTableStatement.Column column = (AnnotatedCreateTableStatement.Column)element$iv;
                boolean bl4 = false;
                if (!caseInsensitive.containsIgnoreCase(column.getSrc().getName())) continue;
                v2 = element$iv;
                break block9;
            }
            v2 = null;
        }
        object = v2;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            return it;
        }
        Object object2 = field;
        if (object2 != null && (object2 = ((AnnotatedSelectStatement.Field)object2).getAnnotations()) != null && (object2 = ((FieldAnnotationOverrides)object2).getPropertyName()) != null) {
            Object object3;
            Object it = object3 = object2;
            boolean bl = false;
            object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object3 : null;
            if (object2 != null) {
                Object v6;
                block10: {
                    Object propertyName = object2;
                    boolean bl5 = false;
                    String string = ((String)propertyName).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                    String propertyLower = string;
                    Iterable $this$firstOrNull$iv = table.getColumns();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        AnnotatedCreateTableStatement.Column column = (AnnotatedCreateTableStatement.Column)element$iv;
                        boolean bl6 = false;
                        String string3 = column.getSrc().getName().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        if (!Intrinsics.areEqual((Object)string3, (Object)propertyLower)) continue;
                        v6 = element$iv;
                        break block10;
                    }
                    v6 = null;
                }
                AnnotatedCreateTableStatement.Column column = v6;
                if (column != null) {
                    AnnotatedCreateTableStatement.Column it2 = column;
                    boolean bl7 = false;
                    return it2;
                }
            }
        }
        return null;
    }

    static /* synthetic */ AnnotatedCreateTableStatement.Column lookupColumnUsingCandidates$default(SelectFieldCodeGenerator selectFieldCodeGenerator, AnnotatedCreateTableStatement annotatedCreateTableStatement, AnnotatedSelectStatement.Field field, LinkedHashSet linkedHashSet, String string, int n, Object object) {
        if ((n & 8) != 0) {
            string = null;
        }
        return selectFieldCodeGenerator.lookupColumnUsingCandidates(annotatedCreateTableStatement, field, linkedHashSet, string);
    }

    private final LinkedHashSet<String> buildColumnNameCandidates(String ... names) {
        LinkedHashSet<String> candidates = new LinkedHashSet<String>();
        String[] $this$forEach$iv = names;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String name = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)name)) continue;
            String trimmed = ((Object)StringsKt.trim((CharSequence)name)).toString();
            this.addNameVariants(trimmed, (Set<String>)candidates);
        }
        return candidates;
    }

    /*
     * WARNING - void declaration
     */
    private final void addNameVariants(String name, Set<String> sink) {
        void $this$filterTo$iv$iv;
        String afterDot;
        if (StringsKt.isBlank((CharSequence)name)) {
            return;
        }
        ((Collection)sink).add(name);
        String withoutSuffix = StringsKt.substringBefore$default((String)name, (char)':', null, (int)2, null);
        if (!StringsKt.isBlank((CharSequence)withoutSuffix)) {
            ((Collection)sink).add(withoutSuffix);
        }
        if (!StringsKt.isBlank((CharSequence)(afterDot = StringsKt.substringAfterLast((String)withoutSuffix, (char)'.', (String)withoutSuffix)))) {
            ((Collection)sink).add(afterDot);
        }
        char[] cArray = new char[]{'_'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)afterDot, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List segments = (List)destination$iv$iv;
        if (segments.size() > 1) {
            Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)segments);
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                int element$iv;
                int index = element$iv = ((IntIterator)object).nextInt();
                boolean bl = false;
                ((Collection)sink).add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)segments, (int)index), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null));
            }
        }
    }

    private final LinkedHashSet<String> buildNameCandidatesFromAliasPrefix(AnnotatedSelectStatement.Field field) {
        LinkedHashSet<String> result;
        block7: {
            Object object;
            Object object2;
            String[] stringArray = new String[]{field.getSrc().getOriginalColumnName(), field.getSrc().getFieldName()};
            result = this.buildColumnNameCandidates(stringArray);
            String aliasPrefix = field.getAnnotations().getAliasPrefix();
            CharSequence charSequence = aliasPrefix;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String it;
                String string = this.removePrefixOrNull(field.getSrc().getFieldName(), aliasPrefix);
                if (string != null) {
                    it = string;
                    boolean bl = false;
                    ((Collection)result).add(it);
                }
                String string2 = this.removePrefixOrNull(field.getSrc().getOriginalColumnName(), aliasPrefix);
                if (string2 != null) {
                    it = string2;
                    boolean bl = false;
                    ((Collection)result).add(it);
                }
            }
            if ((object2 = field.getAnnotations().getSourceTable()) != null) {
                Object it = object = object2;
                boolean bl = false;
                object2 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
                if (object2 != null) {
                    it = object2;
                    boolean bl2 = false;
                    ((Collection)result).add(it);
                }
            }
            Iterable $this$forEach$iv = field.getAliasPath();
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.iterator();
            while (object.hasNext()) {
                Object element$iv = object.next();
                String segment = (String)element$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)segment))) continue;
                ((Collection)result).add(segment);
            }
            Object object3 = field.getAnnotations().getPropertyName();
            if (object3 == null) break block7;
            Object it = object = object3;
            boolean bl = false;
            object3 = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
            if (object3 != null) {
                it = object3;
                boolean bl3 = false;
                ((Collection)result).add(it);
            }
        }
        return result;
    }

    private final LinkedHashSet<String> buildNameCandidates(String ... names) {
        return this.buildColumnNameCandidates(Arrays.copyOf(names, names.length));
    }

    private final AnnotatedCreateViewStatement findViewByName(String name) {
        AnnotatedCreateViewStatement annotatedCreateViewStatement = this.viewMap.get(name);
        if (annotatedCreateViewStatement == null) {
            annotatedCreateViewStatement = this.viewAliasMap.get(name);
        }
        return annotatedCreateViewStatement;
    }

    /*
     * Unable to fully structure code
     */
    private final AnnotatedCreateViewStatement.Field findMatchingViewField(AnnotatedCreateViewStatement view, AnnotatedSelectStatement.Field field, String aliasPrefix, String sourceAlias) {
        block7: {
            candidates = this.buildNameCandidatesFromAliasPrefix(field);
            $this$firstOrNull$iv = view.getFields();
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                viewField = (AnnotatedCreateViewStatement.Field)element$iv;
                $i$a$-firstOrNull-SelectFieldCodeGenerator$findMatchingViewField$1 = false;
                var12_13 = sourceAlias;
                if (var12_13 == null || StringsKt.isBlank((CharSequence)var12_13) != false) ** GOTO lbl-1000
                v0 = viewField.getSrc().getTableName().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"toLowerCase(...)");
                v1 = sourceAlias.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)v0, (Object)v1)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                aliasMatches = v2;
                var14_15 = aliasPrefix;
                if (var14_15 == null || StringsKt.isBlank((CharSequence)var14_15) != false) ** GOTO lbl-1000
                v3 = viewField.getAnnotations().getAliasPrefix();
                if (v3 != null) {
                    v4 = v3.toLowerCase(Locale.ROOT);
                    v5 = v4;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toLowerCase(...)");
                } else {
                    v5 = null;
                }
                v6 = aliasPrefix.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"toLowerCase(...)");
                if (Intrinsics.areEqual((Object)v5, (Object)v6)) lbl-1000:
                // 2 sources

                {
                    v7 = true;
                } else {
                    v7 = false;
                }
                prefixMatches = v7;
                $this$findMatchingViewField_u24lambda_u240_u240 = var15_16 = new CaseInsensitiveSet();
                $i$a$-apply-SelectFieldCodeGenerator$findMatchingViewField$1$candidateSet$1 = false;
                $this$findMatchingViewField_u24lambda_u240_u240.addAll((Iterable<String>)candidates);
                candidateSet = var15_16;
                v8 = (aliasMatches || prefixMatches) && (candidateSet.containsIgnoreCase(viewField.getSrc().getFieldName()) || candidateSet.containsIgnoreCase(viewField.getSrc().getOriginalColumnName()));
                if (!v8) continue;
                v9 = element$iv;
                break block7;
            }
            v9 = null;
        }
        return v9;
    }

    private final String removePrefixOrNull(String $this$removePrefixOrNull, String prefix) {
        String string;
        if (StringsKt.startsWith$default((String)$this$removePrefixOrNull, (String)prefix, (boolean)false, (int)2, null)) {
            String string2;
            String it = string2 = StringsKt.removePrefix((String)$this$removePrefixOrNull, (CharSequence)prefix);
            boolean bl = false;
            string = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        } else {
            string = null;
        }
        return string;
    }

    public SelectFieldCodeGenerator() {
        this(null, null, null, 7, null);
    }
}

