/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.test.annotation;

import com.google.inject.AbstractModule;
import com.google.inject.ConfigurationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import dev.voidframework.core.VoidApplication;
import dev.voidframework.test.annotation.ExtraGuiceModule;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.configuration.injection.scanner.InjectMocksScanner;
import org.mockito.internal.util.MockUtil;
import org.mockito.quality.Strictness;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoidFrameworkJUnitExtension
implements TestInstancePostProcessor,
AfterEachCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(VoidFrameworkJUnitExtension.class);
    private static final ExtensionContext.Namespace NAMESPACE_APP = ExtensionContext.Namespace.create((Object[])new Object[]{"dev", "voidframework", "junit5", "app"});
    private final Set<TrackedInstanceHandler<Object>> trackedInstanceHandlerSet = new HashSet<TrackedInstanceHandler<Object>>();

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.mockMemberAnnotatedWithMock(testInstance);
        Injector mockInjector = this.getOrCreateMockInjector();
        Injector appInjector = this.getOrCreateApplicationInjector(context, testInstance);
        Assertions.assertNotNull((Object)appInjector);
        this.injectMembers(appInjector, mockInjector, testInstance);
    }

    public void afterEach(ExtensionContext context) {
        for (TrackedInstanceHandler<Object> mockedInstanceHandler : this.trackedInstanceHandlerSet) {
            Mockito.reset((Object[])new Object[]{mockedInstanceHandler.instance});
        }
    }

    private Injector getOrCreateMockInjector() {
        AbstractModule mockedValuesModule = new AbstractModule(){

            protected void configure() {
                for (TrackedInstanceHandler<Object> mockedInstanceHandler : VoidFrameworkJUnitExtension.this.trackedInstanceHandlerSet) {
                    this.bind(mockedInstanceHandler.classType).toInstance(mockedInstanceHandler.instance);
                }
            }
        };
        return Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{mockedValuesModule});
    }

    private Injector getOrCreateApplicationInjector(ExtensionContext context, Object testInstance) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (context.getElement().isEmpty()) {
            return null;
        }
        ExtensionContext.Store store = context.getStore(NAMESPACE_APP);
        Injector injector = (Injector)store.get((Object)NAMESPACE_APP, Injector.class);
        if (injector == null) {
            VoidApplication voidApplication = new VoidApplication();
            voidApplication.launch();
            ArrayList<2> moduleList = new ArrayList<2>();
            AbstractModule mockedValuesModule = new AbstractModule(){

                protected void configure() {
                    for (TrackedInstanceHandler<Object> mockedInstanceHandler : VoidFrameworkJUnitExtension.this.trackedInstanceHandlerSet) {
                        this.bind(mockedInstanceHandler.classType).toInstance(mockedInstanceHandler.instance);
                    }
                }
            };
            moduleList.add(mockedValuesModule);
            ExtraGuiceModule extraGuiceModule = testInstance.getClass().getAnnotation(ExtraGuiceModule.class);
            if (extraGuiceModule != null) {
                for (Class<? extends Module> moduleClassType : extraGuiceModule.value()) {
                    Module module = moduleClassType.getConstructor(new Class[0]).newInstance(new Object[0]);
                    moduleList.add(module);
                }
            }
            injector = ((Injector)voidApplication.getInstance(Injector.class)).createChildInjector(moduleList);
            store.put((Object)NAMESPACE_APP, (Object)injector);
        }
        return injector;
    }

    private void mockMemberAnnotatedWithMock(Object testInstance) throws IllegalAccessException {
        for (Class<?> currentClassType = testInstance.getClass(); currentClassType != Object.class; currentClassType = currentClassType.getSuperclass()) {
            List<Field> mockAnnotatedFieldList = Arrays.stream(currentClassType.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Mock.class)).toList();
            for (Field field2 : mockAnnotatedFieldList) {
                Class<?> classType = field2.getType();
                Object currentFieldInstance = this.getValueFromField(testInstance, field2);
                if (MockUtil.isMock((Object)currentFieldInstance)) {
                    this.trackedInstanceHandlerSet.add(TrackedInstanceHandler.of(classType, currentFieldInstance));
                    continue;
                }
                Optional<TrackedInstanceHandler> existingMockedInstanceOptional = this.trackedInstanceHandlerSet.stream().filter(element -> element.classType == classType).findFirst();
                if (existingMockedInstanceOptional.isPresent()) {
                    this.setValueToField(testInstance, field2, existingMockedInstanceOptional.get().instance);
                    continue;
                }
                Mock mockAnnotation = field2.getAnnotation(Mock.class);
                MockSettings mockSettings = Mockito.withSettings().name(mockAnnotation.name()).defaultAnswer((Answer)mockAnnotation.answer());
                if (mockAnnotation.stubOnly()) {
                    mockSettings = mockSettings.stubOnly();
                }
                if (mockAnnotation.serializable()) {
                    mockSettings = mockSettings.serializable();
                }
                if (mockAnnotation.strictness() != Mock.Strictness.TEST_LEVEL_DEFAULT) {
                    Strictness strictness = Strictness.valueOf((String)mockAnnotation.strictness().name());
                    mockSettings = mockSettings.strictness(strictness);
                }
                if (mockAnnotation.extraInterfaces().length > 0) {
                    mockSettings = mockSettings.extraInterfaces(mockAnnotation.extraInterfaces());
                }
                Object mockedInstance = Mockito.mock(classType, (MockSettings)mockSettings);
                if (field2.isAnnotationPresent(Spy.class)) {
                    mockedInstance = Mockito.spy((Object)mockedInstance);
                }
                this.setValueToField(testInstance, field2, mockedInstance);
                TrackedInstanceHandler<Object> mockedInstanceHandler = TrackedInstanceHandler.of(classType, classType.cast(mockedInstance));
                this.trackedInstanceHandlerSet.add(mockedInstanceHandler);
            }
        }
    }

    private void injectMembers(Injector appInjector, Injector mockInjector, Object testInstance) throws IllegalAccessException {
        this.injectMembersAnnotatedWithInjectMocks(mockInjector, testInstance);
        appInjector.injectMembers(testInstance);
        this.injectMembersAnnotatedWithSpyOnly(testInstance);
    }

    private void injectMembersAnnotatedWithInjectMocks(Injector mockInjector, Object testInstance) throws IllegalAccessException {
        HashSet fieldToMockSet = new HashSet();
        InjectMocksScanner injectMocksScanner = new InjectMocksScanner(testInstance.getClass());
        injectMocksScanner.addTo(fieldToMockSet);
        try {
            for (Field field : fieldToMockSet) {
                Class<?> classType = field.getType();
                Object instance = mockInjector.getInstance(classType);
                if (field.isAnnotationPresent(Spy.class)) {
                    instance = Mockito.spy((Object)instance);
                    this.trackedInstanceHandlerSet.add(TrackedInstanceHandler.of(classType, instance));
                }
                this.setValueToField(testInstance, field, instance);
            }
        }
        catch (ConfigurationException exception) {
            LOGGER.error("@InjectMock only works with mocked values!");
            LOGGER.error("If you want to mixing mocked/Not mocked values, consider using @Inject directly.");
            throw exception;
        }
    }

    private void injectMembersAnnotatedWithSpyOnly(Object testInstance) throws IllegalAccessException {
        for (Class<?> currentClassType = testInstance.getClass(); currentClassType != Object.class; currentClassType = currentClassType.getSuperclass()) {
            List<Field> spyAnnotatedFieldList = Arrays.stream(currentClassType.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Spy.class)).filter(field -> !field.isAnnotationPresent(Mock.class)).filter(field -> !field.isAnnotationPresent(InjectMocks.class)).toList();
            for (Field field2 : spyAnnotatedFieldList) {
                Object spiedInstance;
                Class<?> classType;
                Object instance = this.getValueFromField(testInstance, field2);
                if (instance != null && MockUtil.isSpy((Object)instance)) continue;
                if (instance == null) {
                    classType = field2.getType();
                    spiedInstance = Mockito.spy(classType);
                } else {
                    classType = instance.getClass();
                    spiedInstance = Mockito.spy((Object)instance);
                }
                this.setValueToField(testInstance, field2, spiedInstance);
                this.trackedInstanceHandlerSet.add(TrackedInstanceHandler.of(classType, spiedInstance));
            }
        }
    }

    private Object getValueFromField(Object instance, Field field) throws IllegalAccessException {
        boolean canAccess = field.canAccess(instance);
        if (!canAccess) {
            field.setAccessible(true);
        }
        Object value = field.get(instance);
        if (!canAccess) {
            field.setAccessible(false);
        }
        return value;
    }

    private void setValueToField(Object instance, Field field, Object value) throws IllegalAccessException {
        boolean canAccess = field.canAccess(instance);
        if (!canAccess) {
            field.setAccessible(true);
        }
        field.set(instance, value);
        if (!canAccess) {
            field.setAccessible(false);
        }
    }

    private record TrackedInstanceHandler<T>(Class<T> classType, T instance) {
        public static TrackedInstanceHandler<Object> of(Class<?> classType, Object instance) {
            return new TrackedInstanceHandler<Object>(classType, instance);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TrackedInstanceHandler that = (TrackedInstanceHandler)o;
            return this.classType.equals(that.classType);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.classType);
        }
    }
}

