/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.test.utils;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public final class MockitoUtils {
    private MockitoUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <C, L extends C> L spyLambda(Class<C> lambdaClassType, L lambda) {
        return (L)Mockito.mock(lambdaClassType, (Answer)AdditionalAnswers.delegatesTo(lambda));
    }

    public static <C extends Consumer<?>> C spyConsumer(C consumer) {
        return MockitoUtils.spyLambda(Consumer.class, consumer);
    }

    public static <C extends BiConsumer<?, ?>> C spyBiConsumer(C biconsumer) {
        return MockitoUtils.spyLambda(BiConsumer.class, biconsumer);
    }

    public static <F extends Function<?, ?>> F spyFunction(F function) {
        return MockitoUtils.spyLambda(Function.class, function);
    }

    public static <F extends BiFunction<?, ?, ?>> F spyBiFunction(F bifunction) {
        return MockitoUtils.spyLambda(BiFunction.class, bifunction);
    }

    public static <P extends Predicate<?>> P spyPredicate(P predicate) {
        return MockitoUtils.spyLambda(Predicate.class, predicate);
    }

    public static <P extends BiPredicate<?, ?>> P spyBiPredicate(P bipredicate) {
        return MockitoUtils.spyLambda(BiPredicate.class, bipredicate);
    }

    public static <S extends Supplier<?>> S spySupplier(S supplier) {
        return MockitoUtils.spyLambda(Supplier.class, supplier);
    }
}

