/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.exception;

public class HttpsWebServerConfigurationException
extends RuntimeException {
    protected HttpsWebServerConfigurationException(String message, Throwable cause) {
        super(message, cause);
    }

    protected HttpsWebServerConfigurationException(String message) {
        this(message, null);
    }

    public static class KeyNotFound
    extends HttpsWebServerConfigurationException {
        public KeyNotFound(String keyAlias) {
            super("Key identified by alias '" + keyAlias + "' was not found");
        }
    }

    public static class SSLContextInitFailure
    extends HttpsWebServerConfigurationException {
        public SSLContextInitFailure(Throwable cause) {
            super("SSL context cannot be initialized", cause);
        }
    }

    public static class KeyManagerInitFailure
    extends HttpsWebServerConfigurationException {
        public KeyManagerInitFailure(Throwable cause) {
            super("Key manager cannot be initialized", cause);
        }
    }

    public static class CannotLoadKeyStore
    extends HttpsWebServerConfigurationException {
        public CannotLoadKeyStore(Throwable cause) {
            super("Cannot load key store", cause);
        }
    }
}

