/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.web.server.http;

import com.google.inject.Injector;
import com.typesafe.config.Config;
import dev.voidframework.core.conversion.Conversion;
import dev.voidframework.template.TemplateRenderer;
import dev.voidframework.web.exception.HttpException;
import dev.voidframework.web.http.Context;
import dev.voidframework.web.http.Result;
import dev.voidframework.web.http.annotation.NoCSRF;
import dev.voidframework.web.http.annotation.RequestBody;
import dev.voidframework.web.http.annotation.RequestPath;
import dev.voidframework.web.http.annotation.RequestVariable;
import dev.voidframework.web.http.errorhandler.ErrorHandler;
import dev.voidframework.web.http.filter.DefaultFilterChain;
import dev.voidframework.web.http.filter.Filter;
import dev.voidframework.web.http.filter.csrf.CSRFFilter;
import dev.voidframework.web.http.routing.ResolvedRoute;
import dev.voidframework.web.http.routing.Router;
import dev.voidframework.web.server.http.AbstractHttpRequestHandler;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class HttpRequestHandler
extends AbstractHttpRequestHandler {
    private final Injector injector;
    private final List<Class<? extends Filter>> globalFilterClassTypes;
    private final ErrorHandler errorHandler;
    private final Router router;
    private final Config configuration;
    private TemplateRenderer templateRenderer;

    public HttpRequestHandler(Injector injector, ErrorHandler errorHandler, List<Class<? extends Filter>> globalFilterClassTypes) {
        super((Conversion)injector.getInstance(Conversion.class));
        this.injector = injector;
        this.errorHandler = errorHandler;
        this.globalFilterClassTypes = globalFilterClassTypes;
        this.router = (Router)this.injector.getInstance(Router.class);
        this.configuration = (Config)this.injector.getInstance(Config.class);
        try {
            this.templateRenderer = (TemplateRenderer)this.injector.getInstance(TemplateRenderer.class);
        }
        catch (Exception ignore) {
            this.templateRenderer = null;
        }
    }

    public Result onBadRequest(Context context, HttpException.BadRequest cause) {
        return this.errorHandler.onBadRequest(context, cause);
    }

    public Result onRouteRequest(Context context) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        for (Class<? extends Filter> filterClassType : this.globalFilterClassTypes) {
            filterList.add((Filter)this.injector.getInstance(filterClassType));
        }
        ResolvedRoute resolvedRoute = this.router.resolveRoute(context.getRequest().getHttpMethod(), context.getRequest().getRequestURI());
        if (resolvedRoute == null) {
            context.getAttributes().put(CSRFFilter.BYPASS_CSRF_VERIFICATION, (Object)Boolean.TRUE);
            Filter callNotFoundFilter = (ctx, filterChain) -> {
                Result result = this.errorHandler.onNotFound(ctx, null);
                result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                return result;
            };
            filterList.add(callNotFoundFilter);
        } else {
            if (resolvedRoute.controllerClassType().isAnnotationPresent(NoCSRF.class) || resolvedRoute.method().isAnnotationPresent(NoCSRF.class)) {
                context.getAttributes().put(CSRFFilter.BYPASS_CSRF_VERIFICATION, (Object)Boolean.TRUE);
            }
            for (Class clazz : resolvedRoute.filterClassTypes()) {
                filterList.add((Filter)this.injector.getInstance(clazz));
            }
            Filter callControllerFile = (ctx, filterChain) -> {
                Object controllerInstance = this.injector.getInstance(resolvedRoute.controllerClassType());
                try {
                    Result result;
                    if (resolvedRoute.method().getParameterCount() == 0) {
                        result = (Result)resolvedRoute.method().invoke(controllerInstance, new Object[0]);
                    } else {
                        Object[] methodArgumentValueArray = this.buildMethodArguments(ctx, resolvedRoute);
                        result = (Result)resolvedRoute.method().invoke(controllerInstance, methodArgumentValueArray);
                    }
                    result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                    return result;
                }
                catch (Exception exception) {
                    Result result;
                    Throwable cause;
                    Throwable throwable = cause = exception.getCause() == null ? exception : exception.getCause();
                    if (cause instanceof HttpException.NotFound) {
                        HttpException.NotFound causeAsNotFound = (HttpException.NotFound)cause;
                        result = this.errorHandler.onNotFound(ctx, causeAsNotFound);
                    } else if (cause instanceof HttpException.BadRequest) {
                        HttpException.BadRequest causeAsBadRequest = (HttpException.BadRequest)cause;
                        result = this.errorHandler.onBadRequest(ctx, causeAsBadRequest);
                    } else {
                        result = this.errorHandler.onServerError(ctx, exception);
                    }
                    result.getResultProcessor().process(ctx, this.configuration, this.templateRenderer);
                    return result;
                }
            };
            filterList.add(callControllerFile);
        }
        try {
            DefaultFilterChain filterChain2 = new DefaultFilterChain(filterList);
            return filterChain2.applyNext(context);
        }
        catch (Exception exception) {
            Result result = this.errorHandler.onServerError(context, exception);
            result.getResultProcessor().process(context, this.configuration, this.templateRenderer);
            return result;
        }
    }

    private Object[] buildMethodArguments(Context context, ResolvedRoute resolvedRoute) {
        int idx = 0;
        Object[] methodArgumentValueArray = new Object[resolvedRoute.method().getParameterCount()];
        for (Parameter parameter : resolvedRoute.method().getParameters()) {
            if (parameter.getType().isAssignableFrom(Context.class)) {
                methodArgumentValueArray[idx] = context;
                ++idx;
                continue;
            }
            RequestBody requestBody = parameter.getAnnotation(RequestBody.class);
            RequestPath requestPath = parameter.getAnnotation(RequestPath.class);
            RequestVariable requestVariable = parameter.getAnnotation(RequestVariable.class);
            if (requestBody != null) {
                methodArgumentValueArray[idx] = context.getRequest().getBodyContent().contentType() != null ? context.getRequest().getBodyContent().as(parameter.getType()) : null;
            } else if (requestPath != null) {
                methodArgumentValueArray[idx] = this.convertValueToParameterType(resolvedRoute.extractedParameterValues().getOrDefault(requestPath.value(), null), parameter.getType());
            } else if (requestVariable != null) {
                if (parameter.getType().isArray()) {
                    List<String> paramValueList = context.getRequest().getQueryStringParameterAsList(requestVariable.value());
                    if (paramValueList.isEmpty() && !"\u0000\u0000".equals(requestVariable.fallback())) {
                        paramValueList = Arrays.asList(StringUtils.splitByWholeSeparator((String)requestVariable.fallback(), (String)","));
                    }
                    methodArgumentValueArray[idx] = this.convertValuesToParameterTypeArray(paramValueList, (Class<?>)parameter.getType().componentType());
                } else {
                    methodArgumentValueArray[idx] = this.convertValueToParameterType(context.getRequest().getQueryStringParameter(requestVariable.value(), "\u0000\u0000".equals(requestVariable.fallback()) ? null : requestVariable.fallback()), parameter.getType());
                }
            } else {
                methodArgumentValueArray[idx] = this.injector.getInstance(parameter.getType());
            }
            ++idx;
        }
        return methodArgumentValueArray;
    }
}

