package fi.evolver.script.system;

public enum Architecture {

	AMD64, ARM64;

	public static final String OS_ARCH = System.getProperty("os.arch");

	public static final Architecture CURRENT = switch (OS_ARCH) {
		case "amd64" -> AMD64;
		case String s when s.startsWith("arm") || s.contains("aarch64") -> ARM64;
		default -> null;
	};

	public static Architecture validated() {
		if (CURRENT == null) {
			throw new IllegalStateException("Current architecture (%s) is not supported"
					.formatted(System.getProperty("os.arch")));
		}

		return CURRENT;
	}

}
