package fi.evolver.script.app;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;

public class Xfce {

	private static final Path CONFIG_DIR = Shell.HOME.resolve(".config");
	private static final Path AUTOSTART_DIR = CONFIG_DIR.resolve("autostart");

	/**
	 * Write Xfce configuration files to the user's config directory.
	 * @param configDirSource the .tar.gz file to be extracted
	 */
	public static void writeUserConfigDir(Path configDirSource) {
		try (Step step = Step.start("Configure Xfce")) {
			Shell.user("rm", "-rf", CONFIG_DIR.resolve("xfce4").toString());
			Shell.user(
					"tar",
					"xzf",
					configDirSource.toString(),
					"-C",
					CONFIG_DIR.toString());
		}
	}

	public static void configureGnomeKeyringAutostart() throws IOException {
		try (Step step = Step.start("Configure Gnome Keyring autostart")) {
			Files.createDirectories(AUTOSTART_DIR);
			FileUtils.write(AUTOSTART_DIR.resolve("gnome-keyring-ssh.desktop"), """
					[Desktop Entry]
					X-XFCE-Autostart-Override=true
					"""
			);

			Shell.sudo("sed", "-i", "-E", "s/^use-ssh-agent/no-use-ssh-agent/", "/etc/X11/Xsession.options");
		}
	}

	public static void addAutostartScript(String desktopEntryFilename, String name, String execString) throws IOException {
		try (Step step = Step.start("Add autostart script: %s".formatted(name))) {
			Files.createDirectories(AUTOSTART_DIR);
			FileUtils.write(AUTOSTART_DIR.resolve(desktopEntryFilename), """
					[Desktop Entry]
					Type=Application
					Name=%s
					Exec=%s
					Terminal=false
					NoDisplay=false
					OnlyShowIn=XFCE;
					"""
					.formatted(name, execString)
			);
		}
	}
}
