/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.utils.SourceRoot;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class CommentService {
    private static String describe(Node node) {
        if (node instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)node;
            return "Method " + methodDeclaration.getDeclarationAsString();
        }
        if (node instanceof ConstructorDeclaration) {
            ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)node;
            return "Constructor " + constructorDeclaration.getDeclarationAsString();
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            ClassOrInterfaceDeclaration classOrInterfaceDeclaration = (ClassOrInterfaceDeclaration)node;
            if (classOrInterfaceDeclaration.isInterface()) {
                return "Interface " + classOrInterfaceDeclaration.getName();
            }
            return "Class " + classOrInterfaceDeclaration.getName();
        }
        if (node instanceof EnumDeclaration) {
            EnumDeclaration enumDeclaration = (EnumDeclaration)node;
            return "Enum " + enumDeclaration.getName();
        }
        if (node instanceof FieldDeclaration) {
            FieldDeclaration fieldDeclaration = (FieldDeclaration)node;
            List varNames = fieldDeclaration.getVariables().stream().map(v -> v.getName().getId()).collect(Collectors.toList());
            return "Field " + String.join((CharSequence)", ", varNames);
        }
        return node.toString();
    }

    public static void main(String[] args) {
        JavaParser parser = new JavaParser();
        Path sourceDirectory = Paths.get(Paths.get("src", new String[0]).toFile().getAbsolutePath(), new String[0]);
        System.out.println("Root is: " + sourceDirectory.toFile().getAbsolutePath());
        SourceRoot sourceRoot = new SourceRoot(sourceDirectory);
        try {
            List parseResults = sourceRoot.tryToParse();
            parseResults.forEach(result -> result.getCommentsCollection().ifPresent(comments -> comments.getJavadocComments().forEach(javadocComment -> {
                String path = "TODO";
                String title = null;
                title = javadocComment.getCommentedNode().isPresent() ? String.format("%s (%s)", CommentService.describe((Node)javadocComment.getCommentedNode().get()), path) : String.format("No element associated (%s)", path);
                System.out.println(title);
                System.out.println("comment: " + javadocComment.getContent());
                System.out.println("==============================");
            })));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

