/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.infrastructure.client.JacksonConfiguration;
import io.contextmap.model.RestApiEndpoint;
import io.contextmap.model.json.ScannedAnonymousObjectNode;
import io.contextmap.model.json.ScannedArrayNode;
import io.contextmap.model.json.ScannedBooleanNode;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.model.json.ScannedNullNode;
import io.contextmap.model.json.ScannedNumberNode;
import io.contextmap.model.json.ScannedObjectNode;
import io.contextmap.model.json.ScannedStringNode;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PublishedEndpointFromRestDocsService {
    private static final String snippetsFolder = "target/generated-snippets";
    private static final String filenameHttpRequest = "http-request.adoc";
    private static final String filenameRequestBody = "request-body.adoc";
    private static final String filenameResponseBody = "response-body.adoc";

    public List<RestApiEndpoint> scan(Path baseDir) {
        Path snippetFolderPath = baseDir.resolve(snippetsFolder);
        if (!snippetFolderPath.toFile().exists()) {
            return Collections.emptyList();
        }
        try {
            RestDocFolderVisitor visitor = new RestDocFolderVisitor();
            Files.walkFileTree(baseDir, visitor);
            return visitor.getResults();
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for published endpoint based on rest-docs.");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private static ScannedJsonNode convertJsonNodeToScannedJsonNode(JsonNode jsonNode) {
        if (jsonNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ScannedArrayNode scannedArrayNode = new ScannedArrayNode();
            if (!arrayNode.isEmpty()) {
                JsonNode element = arrayNode.get(0);
                scannedArrayNode.setElement(PublishedEndpointFromRestDocsService.convertJsonNodeToScannedJsonNode(element));
            }
            return scannedArrayNode;
        }
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ScannedObjectNode scannedObjectNode = new ScannedObjectNode();
            if (!objectNode.isEmpty()) {
                Iterator iter = objectNode.fieldNames();
                while (iter.hasNext()) {
                    String fieldName = (String)iter.next();
                    JsonNode valueNode = objectNode.get(fieldName);
                    scannedObjectNode.addProperty(fieldName, PublishedEndpointFromRestDocsService.convertJsonNodeToScannedJsonNode(valueNode));
                }
            }
            return scannedObjectNode;
        }
        if (jsonNode instanceof NumericNode) {
            return new ScannedNumberNode();
        }
        if (jsonNode instanceof NullNode) {
            return new ScannedNullNode();
        }
        if (jsonNode instanceof MissingNode) {
            return new ScannedAnonymousObjectNode();
        }
        if (jsonNode instanceof BooleanNode) {
            return new ScannedBooleanNode();
        }
        if (jsonNode instanceof TextNode) {
            return new ScannedStringNode();
        }
        if (jsonNode instanceof POJONode) {
            return new ScannedAnonymousObjectNode();
        }
        if (jsonNode instanceof BinaryNode) {
            return new ScannedAnonymousObjectNode();
        }
        return new ScannedAnonymousObjectNode();
    }

    private static class RestDocFolderVisitor
    extends SimpleFileVisitor<Path> {
        private final List<RestApiEndpoint> results = new ArrayList<RestApiEndpoint>();

        private RestDocFolderVisitor() {
        }

        public List<RestApiEndpoint> getResults() {
            return this.results;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
            if (this.containsNecessaryFiles(dir)) {
                this.addResult(dir);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attr) throws IOException {
            try {
                return super.visitFile(file, attr);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        private boolean containsNecessaryFiles(Path folder) {
            return folder.resolve(PublishedEndpointFromRestDocsService.filenameHttpRequest).toFile().exists() && folder.resolve(PublishedEndpointFromRestDocsService.filenameRequestBody).toFile().exists() && folder.resolve(PublishedEndpointFromRestDocsService.filenameResponseBody).toFile().exists();
        }

        private void addResult(Path folder) {
            try {
                RestApiEndpoint endpoint = new RestApiEndpoint();
                endpoint.description = folder.getFileName().toString();
                this.enrichWithHttpRequestData(endpoint, folder);
                this.enrichWithRequestBody(endpoint, folder);
                this.enrichWithResponseBody(endpoint, folder);
                this.results.add(endpoint);
            }
            catch (Exception e) {
                MojoLogger.logger.warn("Unable to scan for published endpoint at " + folder);
                MojoLogger.logger.debug("Exception", e);
            }
        }

        private void enrichWithRequestBody(RestApiEndpoint endpoint, Path folder) throws Exception {
            Path requestBodyPath = folder.resolve(PublishedEndpointFromRestDocsService.filenameRequestBody);
            String jsonAsString = this.getFileContentBetweenHyphens(requestBodyPath);
            if (jsonAsString.isEmpty()) {
                return;
            }
            endpoint.requestBodyJsonNode = this.convertToScannedJsonNode(jsonAsString);
        }

        private void enrichWithResponseBody(RestApiEndpoint endpoint, Path folder) throws Exception {
            Path responseBodyPath = folder.resolve(PublishedEndpointFromRestDocsService.filenameResponseBody);
            String jsonAsString = this.getFileContentBetweenHyphens(responseBodyPath);
            if (jsonAsString.isEmpty()) {
                return;
            }
            endpoint.responseBodyJsonNode = this.convertToScannedJsonNode(jsonAsString);
        }

        private ScannedJsonNode convertToScannedJsonNode(String jsonAsString) {
            try {
                ObjectMapper objectMapper = JacksonConfiguration.createObjectMapper();
                JsonNode jsonNode = objectMapper.readTree(jsonAsString);
                return PublishedEndpointFromRestDocsService.convertJsonNodeToScannedJsonNode(jsonNode);
            }
            catch (Exception e) {
                MojoLogger.logger.warn("Unable to read json from rest-doc snippet");
                MojoLogger.logger.debug("Exception", e);
                return new ScannedObjectNode();
            }
        }

        private String getFileContentBetweenHyphens(Path file) throws Exception {
            StringBuilder str = new StringBuilder();
            try (LineNumberReader reader = new LineNumberReader(new FileReader(file.toFile()));){
                String line = reader.readLine();
                boolean isStartHyphensRead = false;
                while (line != null) {
                    String cleanLine;
                    if (isStartHyphensRead && !line.startsWith("---") && !(cleanLine = line.trim().replace("\r", "").replace("\n", "")).isEmpty()) {
                        str.append(line);
                        str.append("\n");
                    }
                    if (line.startsWith("---")) {
                        isStartHyphensRead = true;
                    }
                    line = reader.readLine();
                }
            }
            return str.toString();
        }

        private void enrichWithHttpRequestData(RestApiEndpoint endpoint, Path folder) throws Exception {
            Path httpRequestPath = folder.resolve(PublishedEndpointFromRestDocsService.filenameHttpRequest);
            try (LineNumberReader reader = new LineNumberReader(new FileReader(httpRequestPath.toFile()));){
                boolean isStartHyphensRead = false;
                boolean isPathRead = false;
                String line = reader.readLine();
                while (line != null) {
                    if (isPathRead) {
                        break;
                    }
                    if (isStartHyphensRead) {
                        isPathRead = true;
                        String[] parts = line.split(" ");
                        endpoint.requestMethod = parts[0];
                        endpoint.path = parts[1];
                    }
                    if (line.startsWith("---")) {
                        isStartHyphensRead = true;
                    }
                    line = reader.readLine();
                }
            }
        }
    }
}

