/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.domain.resource;

import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.model.ComponentType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class CompositeConfigurationResource
extends ConfigurationResource {
    private List<ConfigurationResource> resources = new ArrayList<ConfigurationResource>();

    public void addConfigurationResource(ConfigurationResource resource) {
        this.resources.add(resource);
    }

    public int getNumberOfAddedResources() {
        return this.resources.size();
    }

    @Override
    public ComponentType getComponentType() {
        return this.getFirstNonNullObject(this.resources.stream().map(ConfigurationResource::getComponentType));
    }

    @Override
    public String getName() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getName));
    }

    @Override
    public String getAliases() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getAliases));
    }

    @Override
    public String getSystemName() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getSystemName));
    }

    @Override
    public String getDecisionRecordFilenameForOverview() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getDecisionRecordFilenameForOverview));
    }

    @Override
    public String getDomainVisionStatement() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getDomainVisionStatement));
    }

    @Override
    public String getTeam() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getTeam));
    }

    @Override
    public String getTeamMail() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getTeamMail));
    }

    @Override
    public String getOrganization() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getOrganization));
    }

    @Override
    public String getUrlDocumentation() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getUrlDocumentation));
    }

    @Override
    public String getUrlVersionControl() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getUrlVersionControl));
    }

    @Override
    public String getUrlIssueManagement() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getUrlIssueManagement));
    }

    @Override
    public String getUrlBuildPipeline() {
        return this.getFirstNonEmptyStringValue(this.resources.stream().map(ConfigurationResource::getUrlBuildPipeline));
    }

    @Override
    public List<String> getGatewayRoutes() {
        for (ConfigurationResource resource : this.resources) {
            List<String> routes = resource.getGatewayRoutes();
            if (routes == null || routes.isEmpty()) continue;
            return routes;
        }
        return Collections.emptyList();
    }

    private String getFirstNonEmptyStringValue(Stream<String> stringStream) {
        return stringStream.filter(Objects::nonNull).filter(text -> !text.isEmpty()).findFirst().orElse(null);
    }

    private <T> T getFirstNonNullObject(Stream<T> objectStream) {
        return objectStream.filter(Objects::nonNull).findFirst().orElse(null);
    }
}

