/*
 * Decompiled with CFR 0.152.
 */
package io.githhub.TradersTeam.grand_node_java_client.network;

import io.githhub.TradersTeam.grand_node_java_client.network.CallX;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okio.Timeout;
import org.jetbrains.annotations.NotNull;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Callback;
import retrofit2.Response;
import retrofit2.Retrofit;

class CallXAdapterFactory
extends CallAdapter.Factory {
    private final OkHttpClient okHttpClient;
    private final Executor callbackExecutor;

    public CallXAdapterFactory(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
        this.callbackExecutor = okHttpClient.dispatcher().executorService();
    }

    public CallXAdapterFactory(OkHttpClient okHttpClient, Executor callbackExecutor) {
        this.okHttpClient = okHttpClient;
        this.callbackExecutor = callbackExecutor;
    }

    public CallAdapter<?, ?> get(@NotNull Type type, Annotation @NotNull [] annotations, @NotNull Retrofit retrofit) {
        if (CallXAdapterFactory.getRawType((Type)type) != CallX.class) {
            return null;
        }
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalStateException("Call must have generic type (e.g., Call<ResponseBody>)");
        }
        Type responseType = CallXAdapterFactory.getParameterUpperBound((int)0, (ParameterizedType)((ParameterizedType)type));
        return new CallXAdapter(responseType, this.okHttpClient, this.callbackExecutor);
    }

    private static class MyCallXAdapter<T>
    implements CallX<T> {
        private final Call<T> call;
        private final OkHttpClient okHttpClient;
        private final Executor callbackExecutor;

        MyCallXAdapter(Call<T> call, OkHttpClient okHttpClient, Executor callbackExecutor) {
            this.call = call;
            this.okHttpClient = okHttpClient;
            this.callbackExecutor = callbackExecutor;
        }

        @NotNull
        public Response<T> execute() throws IOException {
            return this.call.execute();
        }

        public void enqueue(@NotNull Callback<T> callback) {
            this.callbackExecutor.execute(() -> this.call.enqueue(callback));
        }

        public boolean isExecuted() {
            return this.call.isExecuted();
        }

        public void cancel() {
            this.call.cancel();
        }

        public boolean isCanceled() {
            return this.call.isCanceled();
        }

        @NotNull
        public Call<T> clone() {
            return new MyCallXAdapter<T>(this.call.clone(), this.okHttpClient, this.callbackExecutor);
        }

        @NotNull
        public Request request() {
            return this.call.request();
        }

        @NotNull
        public Timeout timeout() {
            return this.call.timeout();
        }

        @Override
        public void enqueue(final @NotNull BiConsumer<Call<T>, Response<T>> onResponse, final @NotNull BiConsumer<Call<T>, Throwable> onFailure) {
            this.callbackExecutor.execute(() -> this.call.enqueue(new Callback<T>(){

                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    callbackExecutor.execute(() -> onResponse.accept(call, response));
                }

                public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                    callbackExecutor.execute(() -> onFailure.accept(call, t));
                }
            }));
        }

        @Override
        public void async(final BiFunction<Response<T>, Throwable, Boolean> callback) {
            this.call.enqueue(new Callback<T>(){

                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    callbackExecutor.execute(() -> {
                        boolean isShutdownNeeded = false;
                        isShutdownNeeded = call.isCanceled() ? ((Boolean)callback.apply(null, new IOException("Canceled"))).booleanValue() : ((Boolean)callback.apply(response, null)).booleanValue();
                        if (isShutdownNeeded) {
                            this.shutdown(okHttpClient);
                        }
                    });
                }

                public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                    callbackExecutor.execute(() -> {
                        boolean isShutdownNeeded = false;
                        isShutdownNeeded = (Boolean)callback.apply(null, t);
                        if (isShutdownNeeded) {
                            this.shutdown(okHttpClient);
                        }
                    });
                }
            });
        }

        @Override
        public void async(final boolean isShutdownNeeded, final Consumer<Response<T>> onSuccess, final Consumer<Throwable> onFailure) {
            this.call.enqueue(new Callback<T>(){

                public void onResponse(@NotNull Call<T> call, @NotNull Response<T> response) {
                    callbackExecutor.execute(() -> {
                        if (call.isCanceled()) {
                            onFailure.accept(new IOException("Canceled"));
                        } else {
                            onSuccess.accept(response);
                        }
                        if (isShutdownNeeded) {
                            this.shutdown(okHttpClient);
                        }
                    });
                }

                public void onFailure(@NotNull Call<T> call, @NotNull Throwable t) {
                    callbackExecutor.execute(() -> {
                        onFailure.accept(t);
                        if (isShutdownNeeded) {
                            this.shutdown(okHttpClient);
                        }
                    });
                }
            });
        }

        private void shutdown(OkHttpClient okHttpClient) {
            if (okHttpClient != null) {
                okHttpClient.dispatcher().executorService().shutdown();
                okHttpClient.connectionPool().evictAll();
            }
        }
    }

    private static final class CallXAdapter<R>
    implements CallAdapter<R, CallX<R>> {
        private final Type responseType;
        private final OkHttpClient okHttpClient;
        private final Executor callbackExecutor;

        CallXAdapter(Type responseType, OkHttpClient okHttpClient, Executor callbackExecutor) {
            this.responseType = responseType;
            this.okHttpClient = okHttpClient;
            this.callbackExecutor = callbackExecutor;
        }

        @NotNull
        public Type responseType() {
            return this.responseType;
        }

        @NotNull
        public CallX<R> adapt(@NotNull Call<R> call) {
            return new MyCallXAdapter<R>(call, this.okHttpClient, this.callbackExecutor);
        }
    }
}

