/*
 * Decompiled with CFR 0.152.
 */
package io.githhub.TradersTeam.grand_node_java_client.network;

import io.githhub.TradersTeam.grand_node_java_client.network.CallXAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class GrandNodeClient {
    private Retrofit retrofit;
    private OkHttpClient okHttpClient;
    private String baseUrl;
    private List<Converter.Factory> converters;
    private boolean isClientAutoShutDowned;
    private String apiKey;
    private Executor callbackExecutor;

    public GrandNodeClient createDefaultInstance() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient.Builder().build();
        }
        this.okHttpClient = this.okHttpClient.newBuilder().addInterceptor(this::apiInterceptor).build();
        if (this.retrofit == null) {
            this.retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).build();
        }
        this.retrofit = this.retrofit.newBuilder().client(this.okHttpClient).build();
        Retrofit.Builder retrofitBuilder = this.retrofit.newBuilder();
        CallXAdapterFactory callXAdapterFactory = this.getCallXAdapterFactory();
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)callXAdapterFactory);
        for (Converter.Factory converter : this.converters) {
            retrofitBuilder.addConverterFactory(converter);
        }
        this.retrofit = retrofitBuilder.build();
        return this;
    }

    @NotNull
    private CallXAdapterFactory getCallXAdapterFactory() {
        CallXAdapterFactory callXAdapterFactory = this.callbackExecutor != null ? new CallXAdapterFactory(this.okHttpClient, this.callbackExecutor) : new CallXAdapterFactory(this.okHttpClient);
        return callXAdapterFactory;
    }

    @NotNull
    private Response apiInterceptor(Interceptor.Chain chain) throws IOException {
        Request.Builder requestBuilder = chain.request().newBuilder();
        requestBuilder = requestBuilder.addHeader("Authorization", "Bearer " + this.apiKey);
        return chain.proceed(requestBuilder.build());
    }

    public <T> T create(Class<T> serviceClass) {
        return (T)this.retrofit.create(serviceClass);
    }

    GrandNodeClient(Retrofit retrofit, OkHttpClient okHttpClient, String baseUrl, List<Converter.Factory> converters, boolean isClientAutoShutDowned, String apiKey, Executor callbackExecutor) {
        this.retrofit = retrofit;
        this.okHttpClient = okHttpClient;
        this.baseUrl = baseUrl;
        this.converters = converters;
        this.isClientAutoShutDowned = isClientAutoShutDowned;
        this.apiKey = apiKey;
        this.callbackExecutor = callbackExecutor;
    }

    public static GrandNodeClientBuilder builder() {
        return new GrandNodeClientBuilder();
    }

    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public List<Converter.Factory> getConverters() {
        return this.converters;
    }

    public boolean isClientAutoShutDowned() {
        return this.isClientAutoShutDowned;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Executor getCallbackExecutor() {
        return this.callbackExecutor;
    }

    public static class GrandNodeClientBuilder {
        private Retrofit retrofit;
        private OkHttpClient okHttpClient;
        private String baseUrl;
        private ArrayList<Converter.Factory> converters;
        private boolean isClientAutoShutDowned;
        private String apiKey;
        private Executor callbackExecutor;

        GrandNodeClientBuilder() {
        }

        public GrandNodeClientBuilder retrofit(Retrofit retrofit) {
            this.retrofit = retrofit;
            return this;
        }

        public GrandNodeClientBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public GrandNodeClientBuilder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public GrandNodeClientBuilder converter(Converter.Factory converter) {
            if (this.converters == null) {
                this.converters = new ArrayList();
            }
            this.converters.add(converter);
            return this;
        }

        public GrandNodeClientBuilder converters(Collection<? extends Converter.Factory> converters) {
            if (converters == null) {
                throw new NullPointerException("converters cannot be null");
            }
            if (this.converters == null) {
                this.converters = new ArrayList();
            }
            this.converters.addAll(converters);
            return this;
        }

        public GrandNodeClientBuilder clearConverters() {
            if (this.converters != null) {
                this.converters.clear();
            }
            return this;
        }

        public GrandNodeClientBuilder isClientAutoShutDowned(boolean isClientAutoShutDowned) {
            this.isClientAutoShutDowned = isClientAutoShutDowned;
            return this;
        }

        public GrandNodeClientBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public GrandNodeClientBuilder callbackExecutor(Executor callbackExecutor) {
            this.callbackExecutor = callbackExecutor;
            return this;
        }

        public GrandNodeClient build() {
            List<Converter.Factory> converters;
            switch (this.converters == null ? 0 : this.converters.size()) {
                case 0: {
                    converters = Collections.emptyList();
                    break;
                }
                case 1: {
                    converters = Collections.singletonList(this.converters.get(0));
                    break;
                }
                default: {
                    converters = Collections.unmodifiableList(new ArrayList<Converter.Factory>(this.converters));
                }
            }
            return new GrandNodeClient(this.retrofit, this.okHttpClient, this.baseUrl, converters, this.isClientAutoShutDowned, this.apiKey, this.callbackExecutor);
        }

        public String toString() {
            return "GrandNodeClient.GrandNodeClientBuilder(retrofit=" + this.retrofit + ", okHttpClient=" + this.okHttpClient + ", baseUrl=" + this.baseUrl + ", converters=" + this.converters + ", isClientAutoShutDowned=" + this.isClientAutoShutDowned + ", apiKey=" + this.apiKey + ", callbackExecutor=" + this.callbackExecutor + ")";
        }
    }
}

