package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition

enum class Cmd(val raw: String) {
    //basic cmd
    Get("get"),
    GetStatus("getStatus"),
    Set("set"),

    //timer v1 cmd
    AddTimer("addTimer"),
    DelTimer("delTimer"),
    ModifyTimer("modifyTimer"),
    PeekTimer("peekTimer"),

    RfScan("rfScan"),
    RfLearn("rfLearn"),
    RfCancel("rfCancel"),
    RfSend("rfSend"),
    RfDel("rfDel"),
    FwUpgrade("fwUpgrade"),
    UpdateUrl("updateUrl"),
    UpdatePort("updatePort"),
    PanelLearn("panelLearn"),
    GetPanel("getPanel"),
    SetPanel("setPanel"),
    DelPanel("delPanel"),

    //input device command
    DoAction("doAction"),
    DoTrigger("doTrigger"),
    InputDeviceLearn("inputDeviceLearn"),
    DelInputDevice("delInputDevice"),
    AddAction("addAction"),
    SetTriggerAction("setTriggerAction"),
    SetTriggerDefaultAction("setTriggerDefaultAction"),
    SetTriggerDelay("setTriggerDelay"),
    GetTriggerStatus("getTriggerStatus"),
    SetTriggerStatus("setTriggerStatus"),
    SetNoDisableTrigger("setNoDisableTrigger"),

    //timer v2 command
    AddTimer2("addTimer2"),
    DelTimer2("delTimer2"),
    ModifyTimer2("modifyTimer2"),

    //AppToServer command
    Login("login"),


    //Ack Cmd
    GetAck("getAck"),
    SetAck("setAck"),
    Timeout("timeout"),
    AddTimerAck("addTimerAck"),
    DelTimerAck("delTimerAck"),
    ModifyTimerAck("modifyTimerAck"),
    PeekTimerAck("peekTimerAck"),
    RfLearnAck("rfLearnAck"),
    RfCancelAck("rfCancelAck"),
    RfSendAck("rfSendAck"),
    RfDelAck("rfDelAck"),
    FwUpgradeAck("fwUpgradeAck"),
    PanelLearnAck("panelLearnAck"),
    PanelAck("panelAck"),

    //input device cmd ack
    DoTriggerAck("doTriggerAck"),
    GetTriggerAck("getTriggerAck"),
    GetActionAck("getActionAck"),
    InputDeviceLearnAck("inputDeviceLearnAck"),
    DelInputDeviceAck("delInputDeviceAck"),
    AddActionAck("addActionAck"),
    SetTriggerActionAck("setTriggerActionAck"),
    SetTriggerDefaultActionAck("setTriggerDefaultActionAck"),
    SetTriggerDelayAck("setTriggerDelayAck"),
    TriggerStatusAck("triggerStatusAck"),
    NoDisableTriggerAck("noDisableTriggerAck"),

    //timer v2 cmd ack
    AddTimer2Ack("addTimer2Ack"),
    GetTimerAck("getTimerAck"),
    DelTimer2Ack("delTimer2Ack"),
    ModifyTimer2Ack("modifyTimer2Ack"),

    //login ack
    LoginAck("loginAck");


    companion object {
        private val mapping = values().associateBy(Cmd::raw)
        fun fromRaw(raw: String) = mapping[raw]
    }
}

//enum class CmdAck constructor(val raw: String) {
//
//}
