package com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent

import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.Serializable

enum class WeekMaskIndex(val raw: Int) {
    Sunday(raw = 0),
    Monday(raw = 1),
    Tuesday(raw = 2),
    Wednesday(raw = 3),
    Thursday(raw = 4),
    Friday(raw = 5),
    Saturday(raw = 6);

    companion object {
        private val mapping = values().associateBy(WeekMaskIndex::raw)
        fun fromRaw(raw: Int) = mapping[raw]
    }
}

@Serializable
class WeekMask {
    private var weekMaskBooleanList: MutableList<Boolean> =
        mutableListOf(false, false, false, false, false, false, false)

    constructor() {
    }

    constructor(weekMask: WeekMask) {
        WeekMaskIndex.values().forEach {
            weekMaskBooleanList[it.raw] = weekMask.getWeekMaskBit(it)
        }
    }

    constructor(boolList: List<Boolean>) {
        if (boolList.count() >= weekMaskBooleanList.count()) {
            (0 until weekMaskBooleanList.count()).forEach {
                weekMaskBooleanList[it] = boolList[it]
            }
        } else {
            (0 until boolList.count()).forEach {
                weekMaskBooleanList[it] = boolList[it]
            }
        }
    }


    fun setFromWeekMask(weekMask: WeekMask) {
        WeekMaskIndex.values().forEach {
            weekMaskBooleanList[it.raw] = weekMask.getWeekMaskBit(it)
        }
    }

    fun setFromBoolList(boolList: List<Boolean>) {
        if (boolList.count() >= weekMaskBooleanList.count()) {
            (0 until weekMaskBooleanList.count()).forEach {
                weekMaskBooleanList[it] = boolList[it]
            }
        } else {
            (0 until boolList.count()).forEach {
                weekMaskBooleanList[it] = boolList[it]
            }
        }
    }

//    fun initialFromHexString(hexString: String) {
//        HexToolKit.hexStringToBoolList(hexString, 7)?.let { boolList ->
//            (0 until 7).forEach {
//                weekMaskBooleanList[it] = boolList[it]
//            }
//        }
//    }
//
//    
//    fun initialFromNumber(number: ULong) {
//        val boolListFromNumber = HexToolKit.longToBoolList(number, 7)
//        (0 until 7).forEach {
//            weekMaskBooleanList[it] = boolListFromNumber[it]
//        }
//    }

    fun getWeekMaskBit(weekMaskIndex: WeekMaskIndex): Boolean {
        return weekMaskBooleanList[weekMaskIndex.raw]
    }

    fun setWeekMaskBit(weekMaskIndex: WeekMaskIndex, bitValue: Boolean) {
        weekMaskBooleanList[weekMaskIndex.raw] = bitValue
    }

    fun toHexString(): String {
        return HexToolKit.boolListToHexString(weekMaskBooleanList)
    }

   
    fun toULong(): ULong {
        return HexToolKit.boolListToLong(weekMaskBooleanList)
    }

   
    fun isEmpty(): Boolean {
        return toULong() == 0.toULong()
    }

//    fun freezeSelf() {
//        freeze(this)
//    }
}