package com.sentray.kmmprotocolmodule.tcpProtocol.protocolParser.parserUtil

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolComm
import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject
import kotlinx.serialization.json.jsonObject

internal class StickPackageHandler {
    private var revStringCache = ""
//    private var readwriteMutex = Mutex()

    fun split(revMessage: String): List<JsonObject> {
        var cacheStringAfterParse = ""
        val validJsonObjectList = arrayListOf<JsonObject>()

        revStringCache += revMessage

        val jsonPackageStringList = revStringCache.split(ProtocolComm.Suffix.raw)

        for (index in (0 until jsonPackageStringList.count())) {
            val jsonPackageStr = jsonPackageStringList[index]

            //忽略空包
            if (jsonPackageStr.isEmpty()) {
                continue
            }

            //判断是否有 @@@ or $$$
            var startIndex = jsonPackageStr.indexOf(ProtocolComm.LanPrefix.raw)
            if (startIndex < 0) {
                startIndex = jsonPackageStr.indexOf(ProtocolComm.WanPrefix.raw)
            }

            if (startIndex >= 0) {
                //若存在开始符，则判断为有效包，去除头尾部
                val validJsonString = jsonPackageStr.substring(startIndex + 3)
                //测试是否为有效 json 字符串，若是，则加入 validJsonStringList，若不是，则缓存起来，等待下一个数据包一并处理
                try {
                    val validJsonObject = Json.parseToJsonElement(validJsonString).jsonObject
                    validJsonObjectList.add(validJsonObject)

                    //若为最后一包正常包，则判断为本次数据处理完成，清空cache
                    if (index == jsonPackageStringList.count() - 1) {
                        cacheStringAfterParse = ""
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                    KMMLogger.d("RecPackageHandler : 无效包，等待下一包处理 : $jsonPackageStr")

                    //若为最后一包处理异常，判断为不完整包，保留此包数据，等待接受到下一包数据时合并处理
                    if (index == jsonPackageStringList.count() - 1) {
                        cacheStringAfterParse = jsonPackageStr
                    }
                }
            } else {
                //若最后一包不存在开始符，则判断此包异常，丢弃
                if (index == jsonPackageStringList.count() - 1) {
                    KMMLogger.d("RecPackageHandler : 无效包，丢弃 : $jsonPackageStr")
                    cacheStringAfterParse = ""
                }
            }
        }
        revStringCache = cacheStringAfterParse

        return validJsonObjectList
    }
}