package com.sentray.kmmprotocolmodule.cryptor.baseCryptor

import com.sentray.kmmprotocolmodule.cryptor.common.hash.encodeToUByteArray
import com.sentray.kmmprotocolmodule.cryptor.common.hash.sha.Sha512Pure
import kotlin.jvm.JvmStatic

@OptIn(ExperimentalUnsignedTypes::class)
internal class UserPwdGenerator {
    private enum class Keys(val raw: String) {
        //SHA512加密
        SHA512_SALT("Fx9.6`:@ti(~"),
    }

    companion object {
        @ExperimentalStdlibApi
        @JvmStatic
        fun pwdGenerator(userPwdRaw: String): String {
            val raw = Keys.SHA512_SALT.raw + userPwdRaw
            val result = Sha512Pure.digest(raw.encodeToUByteArray())
            var hex = ""
            result.forEach {
                var hexChar = it.toString(16)
                if (hexChar.length == 1) {
                    hexChar = "0$hexChar"
                }
                hex += hexChar

            }
            return hex
        }
    }
}

