package com.sentray.kmmprotocolmodule.utilityToolKit.genericClasses

import kotlinx.coroutines.*
import kotlinx.coroutines.flow.*
import kotlin.time.Duration

internal class KmmTimer {
    private var flow: Flow<Unit>? = null
    private var timeoutJob: Job? = null
    private var running = false

    fun startTimeout(delay: Duration, block: () -> Unit): Boolean {
        var result = false
        if (timeoutJob == null) {
            timeoutJob = CoroutineScope(Dispatchers.Default).launch {
                delay(delay)
                block.invoke()
                timeoutJob = null
            }
            result = true
        }
        return result
    }

    fun cancelTimeout() {
        timeoutJob?.let { timeoutJobValid ->
            if (!timeoutJobValid.isCompleted) {
                timeoutJobValid.cancel(CancellationException("User Stop"))
            }
        }
        timeoutJob = null
    }

    fun startScheduleTimer(
        period: Duration,
        initialDelay: Duration = Duration.ZERO,
        block: () -> Unit
    ): Boolean {
        var result = false
        if (!running) {
            running = true
            flow = tickerFlow(period, initialDelay).cancellable().also {
                it.onEach { block.invoke() }.launchIn(CoroutineScope(Dispatchers.Default))
            }
            result = true
        }
        return result
    }

    fun stopScheduleTimer() {
        running = false
    }

    private fun tickerFlow(period: Duration, initialDelay: Duration = Duration.ZERO) = flow {
        delay(initialDelay)
        while (running) {
            emit(Unit)
            delay(period)
        }
        currentCoroutineContext().cancel()
    }
}