package com.sentray.kmmprotocolmodule.dababase.model

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ControllableApplianceInfo
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.DetectableApplianceInfo
import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ParserResult
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.FactoryID
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProductionID
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.FirmwareVersion

class WiFiDeviceModel(val sn: String) {
    var mac: String = ""
    var fwVersion: FirmwareVersion = FirmwareVersion()

    internal var protocolVersion: ProtocolVersion = ProtocolVersion.V0
    internal var factoryID: FactoryID = FactoryID.WILINK
    internal var productionID: ProductionID = ProductionID.None
    internal var hardwareID = 0


    //TODO：如何处理可重入问题，如何保证 UI 处理完毕前不被后续来的中控回复修改
    private var updatedApplianceInfo = UpdatedApplianceInfo()

    private val controllableApplianceInfoMap: MutableMap<String, ControllableApplianceInfo> = mutableMapOf()
    private val detectableApplianceInfoMap: MutableMap<String, DetectableApplianceInfo> = mutableMapOf()
    
    internal fun parse(parserResult: ParserResult): UpdatedInfo {
        val updatedInfo = UpdatedInfo()
        updatedApplianceInfo = UpdatedApplianceInfo()

        parserResult.controllableDeviceInfo?.let { controllableDeviceInfo ->
            controllableDeviceInfo.updatedControllableApplianceInfoList?.forEach { updatedControllableApplianceInfo ->
                insertOrUpdateControllableApplianceInfo(updatedControllableApplianceInfo)
            }
            //TODO: 其他信息处理
        }
        parserResult.detectableDeviceInfo?.let { detectableDeviceInfo ->
            detectableDeviceInfo.updatedDetectableApplianceInfoList?.forEach { updatedDetectableApplianceInfo ->
                insertDetectableApplianceInfo(updatedDetectableApplianceInfo)
            }
            //TODO: 其他信息处理
        }
        updatedInfo.updatedApplianceInfo = updatedApplianceInfo

        return updatedInfo
    }

    internal fun insertOrUpdateControllableApplianceInfo(controllableApplianceInfoNew: ControllableApplianceInfo) {
        val key = controllableApplianceInfoNew.createKey()
        var updateType: UpdatedApplianceInfo.EUpdateType = UpdatedApplianceInfo.EUpdateType.Unchanged
        controllableApplianceInfoMap[key]?.let {
            //TODO：更新内部数据, 如果真有改变数据，则 updateType 修改为 Modify，否则保持 Unchanged
            if (true) {
                updateType = UpdatedApplianceInfo.EUpdateType.Modify
            }
        } ?: run {
            controllableApplianceInfoMap[key] = controllableApplianceInfoNew
            updateType = UpdatedApplianceInfo.EUpdateType.Add
        }

        updatedApplianceInfo.insertUpdatedControllableApplianceInfo(controllableApplianceInfoNew, updateType)
    }

    internal fun deleteControllableApplianceInfo(controllableApplianceInfoToDel: ControllableApplianceInfo) {
        val key = controllableApplianceInfoToDel.createKey()
        controllableApplianceInfoMap[key]?.let {
            updatedApplianceInfo.insertUpdatedControllableApplianceInfo(
                controllableApplianceInfoToDel, UpdatedApplianceInfo.EUpdateType.Delete
            )

            controllableApplianceInfoMap.remove(key)
        }
    }

    internal fun deleteControllableApplianceInfoViaDeviceTypeSet(installedDeviceTypeSetList: List<DeviceTypeSet>) {
        controllableApplianceInfoMap.keys.forEach { key ->
            controllableApplianceInfoMap[key]?.let { controllableApplianceInfo ->
                if (!installedDeviceTypeSetList.contains(controllableApplianceInfo.devType)) {

                    updatedApplianceInfo.insertUpdatedControllableApplianceInfo(
                        controllableApplianceInfo, UpdatedApplianceInfo.EUpdateType.Delete
                    )

                    controllableApplianceInfoMap.remove(key)
                }
            }
        }
    }

    internal fun insertDetectableApplianceInfo(detectableApplianceInfoNew: DetectableApplianceInfo) {
        val key = detectableApplianceInfoNew.createKey()
        var updateType: UpdatedApplianceInfo.EUpdateType = UpdatedApplianceInfo.EUpdateType.Unchanged
        detectableApplianceInfoMap[key]?.let {
            //TODO：更新内部数据, 如果真有改变数据，则 updateType 修改为 Modify，否则保持 Unchanged
            if (true) {
                updateType = UpdatedApplianceInfo.EUpdateType.Modify
            }
        } ?: run {
            detectableApplianceInfoMap[key] = detectableApplianceInfoNew
            updateType = UpdatedApplianceInfo.EUpdateType.Add
        }

        updatedApplianceInfo.insertUpdatedDetectableApplianceInfo(detectableApplianceInfoNew, updateType)
    }

    internal fun deleteDetectableApplianceInfo(detectableApplianceInfoToDel: DetectableApplianceInfo) {
        val key = detectableApplianceInfoToDel.createKey()
        detectableApplianceInfoMap[key]?.let {
            updatedApplianceInfo.insertUpdatedDetectableApplianceInfo(
                detectableApplianceInfoToDel, UpdatedApplianceInfo.EUpdateType.Delete
            )

            detectableApplianceInfoMap.remove(key)
        }
    }
}