package com.sentray.kmmprotocolmodule.sdk.command

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.AdditionsAndDeletionsCmdCreator
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.CommandData
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.Util
import kotlin.jvm.JvmStatic

//设备添加删除命令
class AddAndDelDeviceCmd {
    companion object {
        @JvmStatic
        fun startScan(
            sn: String,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return AdditionsAndDeletionsCmdCreator.startDeviceScan(
                sn,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun stopScan(
            sn: String,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return AdditionsAndDeletionsCmdCreator.stopDeviceScan(
                sn,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun addRF433Device(
            sn: String,
            devTypeSet: DeviceTypeSet,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return AdditionsAndDeletionsCmdCreator.addRF433Device(
                sn,
                devTypeSet,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun deleteControllableDevice(
            sn: String,
            devTypeSet: DeviceTypeSet,
            applianceIndex: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val deviceIndex = Util.getDeviceIndex(devTypeSet, applianceIndex)
            return AdditionsAndDeletionsCmdCreator.deleteDevice(
                sn,
                devTypeSet,
                deviceIndex,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun deleteControllableDeviceViaDeviceIndex(
            sn: String,
            devTypeSet: DeviceTypeSet,
            deviceIndex: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return AdditionsAndDeletionsCmdCreator.deleteDevice(
                sn,
                devTypeSet,
                deviceIndex,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun deleteDetectableDevice(
            sn: String,
            devTypeSet: DeviceTypeSet,
            deviceIndex: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return AdditionsAndDeletionsCmdCreator.deleteDevice(
                sn,
                devTypeSet,
                deviceIndex,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }
    }
}