package com.sentray.kmmprotocolmodule.sdk.command

import com.sentray.kmmprotocolmodule.sdk.parser.parserResult.ControllableApplianceInfo
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeClassify
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.OnOffStatus
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.paraContent.ParaStructure
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.CommandData
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator.ConfigCmdCreator
import kotlin.jvm.JvmStatic

//设备配置命令
class ConfigureCmd {
    companion object {
        @JvmStatic
        fun modifyApplianceOnOffStatus(
            controllableApplianceInfo: ControllableApplianceInfo,
            onOffStatus: OnOffStatus,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            return ConfigCmdCreator.modifyApplianceOnOffStatus(
                controllableApplianceInfo.sn,
                controllableApplianceInfo.devType,
                controllableApplianceInfo.applianceIndex,
                onOffStatus,
                protocolVersion = protocolVersion,
                networkType = networkType
            )
        }

        @JvmStatic
        fun modifyMinimumBrightPercent(
            controllableApplianceInfo: ControllableApplianceInfo,
            minBrightPercent: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            return when {
                DeviceTypeClassify.isDimmerDevice(controllableApplianceInfo.devType) -> ConfigCmdCreator.setMinBrightPercent(
                    controllableApplianceInfo.sn,
                    controllableApplianceInfo.devType,
                    controllableApplianceInfo.applianceIndex,
                    minBrightPercent,
                    protocolVersion = protocolVersion,
                    networkType = networkType
                )
                else -> null
            }
        }

        @JvmStatic
        fun modifyTurnOnBrightPercent(
            controllableApplianceInfo: ControllableApplianceInfo,
            turnOnBrightPercent: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            return when {
                DeviceTypeClassify.isDimmerDevice(controllableApplianceInfo.devType) -> ConfigCmdCreator.setTurnOnBrightPercent(
                    controllableApplianceInfo.sn,
                    controllableApplianceInfo.devType,
                    controllableApplianceInfo.applianceIndex,
                    turnOnBrightPercent,
                    protocolVersion = protocolVersion,
                    networkType = networkType
                )
                else -> null
            }
        }

        @JvmStatic
        fun modifyTemperatureLedTurnOnPara(
            controllableApplianceInfo: ControllableApplianceInfo,
            turnOnBrightPercent: Int,
            turnOnTemperaturePercent: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {

            return when {
                DeviceTypeClassify.isTemperatureLampDevice(controllableApplianceInfo.devType) -> {
                    return ConfigCmdCreator.setTempLedTurnOnPara(
                        controllableApplianceInfo.sn,
                        controllableApplianceInfo.devType,
                        controllableApplianceInfo.applianceIndex,
                        turnOnBrightPercent,
                        turnOnTemperaturePercent,
                        protocolVersion = protocolVersion,
                        networkType = networkType
                    )
                }
                else -> null
            }
        }

        @JvmStatic
        fun modifyOnOffBrightAdjustSpeed(
            controllableApplianceInfo: ControllableApplianceInfo,
            adjustSpeed: Int,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            return when {
                DeviceTypeClassify.isDimmerDevice(controllableApplianceInfo.devType) || DeviceTypeClassify.isTemperatureLampDevice(
                    controllableApplianceInfo.devType
                ) -> ConfigCmdCreator.setOnOffBrightAdjustSpeed(
                    controllableApplianceInfo.sn,
                    controllableApplianceInfo.devType,
                    controllableApplianceInfo.applianceIndex,
                    adjustSpeed,
                    protocolVersion = protocolVersion,
                    networkType = networkType
                )
                else -> null
            }
        }

        @JvmStatic
        fun modifyRGBDeviceTurnOnPara(
            controllableApplianceInfo: ControllableApplianceInfo,
            para: ParaStructure,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData? {
            return when {
                DeviceTypeClassify.isRGBLampDevice(controllableApplianceInfo.devType) ||
                        DeviceTypeClassify.isRGBWLampDevice(controllableApplianceInfo.devType) -> ConfigCmdCreator.setRGBWTurnOnColor(
                    controllableApplianceInfo.sn,
                    controllableApplianceInfo.devType,
                    controllableApplianceInfo.applianceIndex,
                    para,
                    protocolVersion = protocolVersion,
                    networkType = networkType
                )
                else -> null
            }
        }
    }
}