package com.sentray.kmmprotocolmodule.task.commandSender

import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.utilityToolKit.asyncKit.KAsync

internal class CmdSenderTask {
    companion object {
        fun send(
            mac: String,
            message: String,
            priority: SchedulePoster.ECmdPriority = SchedulePoster.ECmdPriority.Low,
            networkType: ENetworkType = ENetworkType.Cloud
        ) {
            //1. 找到对应的中控

            //2. 若 networkType 为 auto，则判断在线方式，优先 WebSocket 及 Cloud 模式

            //3. 判断发送间隔
            val posterData = PosterData(mac, message, networkType)

            KAsync.background {
                SchedulePoster.pushToQueue(
                    posterData,
                    SchedulePoster.EQueueType.Queue100ms,
                    priority
                )
            }
            //4. 生成命令缓冲数据
        }
    }
}