package com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator

import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeUtil
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.Cmd
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.FactoryID
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import com.sentray.kmmprotocolmodule.utilityToolKit.HexToolKit
import kotlinx.serialization.ExperimentalSerializationApi
import kotlinx.serialization.Serializable
import kotlinx.serialization.encodeToString
import kotlinx.serialization.json.Json
import kotlin.jvm.JvmStatic

@OptIn(ExperimentalSerializationApi::class)
internal class LinkageCmdCreator {
    companion object {
        @Serializable
        data class AddActionPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val devType: Int,
            val rlyAction: String,
            val rlyMask: String,
            val para: List<Long>,
            val paraMask: String,
        )

        @JvmStatic
        fun addAction(
            sn: String,
            deviceTypeSet: DeviceTypeSet,
            applianceActionList: List<Boolean>,
            applianceMaskList: List<Boolean>,
            paraList: List<Long>,
            paraMaskList: List<Boolean>,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val deviceTypeNum = DeviceTypeUtil.findDeviceTypeNumber(deviceTypeSet.raw) ?: 0

            val seq = Util.randomSeq()
            val para = AddActionPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.AddAction.raw,
                deviceTypeNum,
                HexToolKit.boolListToHexString(applianceActionList),
                HexToolKit.boolListToHexString(applianceMaskList),
                paraList,
                HexToolKit.boolListToHexString(paraMaskList)
            )
            val cmdRaw = Json.encodeToString(para)
            val cmd = Util.encode(cmdRaw, protocolVersion, networkType)

            return CommandData(seq, cmd)
        }

        @Serializable
        data class SetTriggerActionPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val triggerIndex: Int,
            val actionMask: String,
            val triggerStatus: String,
            val triggerMask: String,
        )

        @JvmStatic
        fun setTriggerAction(
            sn: String,
            triggerIndex: Int,
            userActionMaskList: List<Boolean>,
            triggerStatusList: List<Boolean>,
            triggerMaskList: List<Boolean>,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = SetTriggerActionPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.SetTriggerAction.raw,
                triggerIndex,
                HexToolKit.boolListToHexString(userActionMaskList),
                HexToolKit.boolListToHexString(triggerStatusList),
                HexToolKit.boolListToHexString(triggerMaskList)
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @Serializable
        data class SetTriggerDefaultActionPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val triggerIndex: Int,
            val defaultActionMask: String,
        )

        @JvmStatic
        fun setTriggerDefaultAction(
            sn: String,
            triggerIndex: Int,
            defaultActionMaskList: List<Boolean>,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = SetTriggerDefaultActionPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.SetTriggerDefaultAction.raw,
                triggerIndex,
                HexToolKit.boolListToHexString(defaultActionMaskList)
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @Serializable
        data class SetTriggerDelayPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val triggerIndex: Int,
            val delay: Int,
        )

        @JvmStatic
        fun setTriggerDelay(
            sn: String,
            triggerIndex: Int,
            delaySecond: Int,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = SetTriggerDelayPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.SetTriggerDelay.raw,
                triggerIndex,
                delaySecond
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @Serializable
        data class SetTriggerStatusPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val triggerStatus: String,
            val triggerMask: String,
        )

        @JvmStatic
        fun setTriggerStatus(
            sn: String,
            triggerStatusList: List<Boolean>,
            triggerMaskList: List<Boolean>,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = SetTriggerStatusPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.SetTriggerStatus.raw,
                HexToolKit.boolListToHexString(triggerStatusList),
                HexToolKit.boolListToHexString(triggerMaskList)
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }

        @Serializable
        data class SetEmergencyTriggerPara(
            val sn: String,
            val seq: Int,
            val factoryID: Int,
            val cmd: String,
            val noDisableTrigger: String,
            val triggerMask: String,
        )

        @JvmStatic
        fun setEmergencyTrigger(
            sn: String,
            emergencyTriggerList: List<Boolean>,
            triggerMaskList: List<Boolean>,
            factoryID: FactoryID = FactoryID.WILINK,
            protocolVersion: ProtocolVersion = ProtocolVersion.V2,
            networkType: ENetworkType = ENetworkType.Cloud
        ): CommandData {
            val seq = Util.randomSeq()
            val para = SetEmergencyTriggerPara(
                sn,
                seq,
                factoryID.raw,
                Cmd.SetNoDisableTrigger.raw,
                HexToolKit.boolListToHexString(emergencyTriggerList),
                HexToolKit.boolListToHexString(triggerMaskList)
            )
            val cmdRaw = Json.encodeToString(para)
            val cmdString = Util.encode(cmdRaw, protocolVersion, networkType)
            return CommandData(seq, cmdString)
        }
    }
}