package com.sentray.kmmprotocolmodule.tcpProtocol.protocolCreator

import com.sentray.kmmprotocolmodule.cryptor.baseCryptor.L1DataCryptor
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeClassify
import com.sentray.kmmprotocolmodule.tcpProtocol.definition.deviceType.DeviceTypeSet
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ENetworkType
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolComm
import com.sentray.kmmprotocolmodule.tcpProtocol.protocolContent.enumDefinition.ProtocolVersion
import io.ktor.util.date.*
import kotlin.jvm.JvmStatic
import kotlin.random.Random

internal class Util {
    companion object {
        @JvmStatic
        internal fun randomSeq(): Int {
            //返回一个“[0, n) 之间的int类型”的随机数。
            return Random.nextInt(0, (getTimeMillis() % 1000000000).toInt())
        }

        @JvmStatic
        internal fun encode(
            cmdRaw: String,
            protocolVersion: ProtocolVersion,
            networkType: ENetworkType
        ): String {
            var cmdString = cmdRaw
            if (protocolVersion == ProtocolVersion.V2) {
                L1DataCryptor.encode(cmdRaw)?.let {
                    cmdString = it
                }
            }

            val result = when (networkType) {
                ENetworkType.Lan -> {
                    ProtocolComm.LanPrefix.raw + cmdString + ProtocolComm.Suffix.raw
                }
                ENetworkType.Cloud -> {
                    ProtocolComm.WanPrefix.raw + cmdString + ProtocolComm.Suffix.raw
                }
            }

            return result
        }

        @JvmStatic
        fun getApplianceAmount(deviceTypeSet: DeviceTypeSet): Int {
            return when {
                DeviceTypeClassify.is4SocketDevice(deviceTypeSet) -> 4
                DeviceTypeClassify.is3SocketDevice(deviceTypeSet) -> 3
                DeviceTypeClassify.is2SocketDevice(deviceTypeSet) -> 2
                else -> 1
            }
        }

        @JvmStatic
        fun getDeviceIndex(deviceTypeSet: DeviceTypeSet, applianceIndex: Int): Int {
            val applianceAmount = getApplianceAmount(deviceTypeSet)
            return applianceIndex / applianceAmount
        }
    }
}