package com.sentray.kmmprotocolmodule.utilityToolKit

import kotlin.jvm.JvmStatic


internal class HexToolKit {
    companion object {
        @JvmStatic
        fun hexStringToBoolList(hexString: String, expectLength: Int = 0): List<Boolean>? {
            var boolList: MutableList<Boolean>? = mutableListOf()

            //1. 从个位开始，逐位转换 (1f3f3aaa)
            try {
                (hexString.length - 1 downTo 0).forEach { it ->
                    val hexChar = hexString[it].toString()
                    val number = hexChar.toInt(radix = 16)
                    //每个 number 代表 4 个 bit
                    (0 until 4).forEach { bitIndex ->
                        val bitValue = (number and (1 shl bitIndex)) > 0
                        boolList?.add(bitValue)
                    }
                }

                //若有指定长度，则高位填充 0
                boolList?.let {
                    while (it.count() < expectLength) {
                        it.add(false)
                    }
                }
            } catch (e: Exception) {
                e.printStackTrace()
                //说明 hex 并非十六进制ƒ数，转换错误
                boolList = null
            }

            //2. 根据 hex 计算 bit 长度 ()
            return boolList
        }

        //just for test only
        @JvmStatic
        fun boolListToBitString(boolList: List<Boolean>): String {
            val boolString = StringBuilder()
            (boolList.count() - 1 downTo 0).forEach {
                boolString.append(
                    when (boolList[it]) {
                        true -> "1"
                        false -> "0"
                    }
                )
            }
//            println(boolString.toString())
            return boolString.toString()
        }

        @JvmStatic
        fun boolListToHexString(boolList: List<Boolean>): String {
            val hexStringBuilder = StringBuilder()

            //1. 4bit 为一组进行分组操作
            val boolGroupList = boolList.chunked(4)

            //2. 每组单独计算 hex 值
            (boolGroupList.count() - 1 downTo 0).forEach {
                var number = 0
                val boolGroup = boolGroupList[it]
                (0 until boolGroup.count()).forEach { bitIndex ->
                    if (boolGroup[bitIndex]) {
                        //x |= 1 << bitIndex
                        number = number or (1 shl bitIndex)
                    }
                }
                hexStringBuilder.append(number.toString(16))
            }

            var hexString = hexStringBuilder.toString()
            //3. 去除高位无效的 0，若为全零，则会把 hexString 清空
            if (hexString.count() > 1 && hexString[0] == '0') {
                hexString = hexString.replaceFirst(Regex("^0*"), "")
            }

            //4. 若 hexString 被清空，则补一个 '0'
            if (hexString.count() == 0) {
                hexString = "0"
            }

            return hexString.uppercase()
        }

       
        @JvmStatic
        fun hexStringToULong(hexString: String): ULong? {
            return try {
                hexString.toULongOrNull(radix = 16)
            } catch (e: Exception) {
                e.printStackTrace()
                null
            }
        }

       
        @JvmStatic
        fun longToBoolList(number: ULong, expectLength: Int = 0): List<Boolean> {
            val boolList = mutableListOf<Boolean>()

            var numberTmp = number

            while (numberTmp != 0UL) {
                boolList.add((numberTmp and 1UL) > 0UL)
                numberTmp = numberTmp shr 1
            }

            while (boolList.count() < expectLength) {
                boolList.add(false)
            }

            //避免空 boolList
            if (boolList.isEmpty()) {
                boolList.add(false)
            }

            return boolList
        }


        @JvmStatic
        //Bool List 转换为 ULong，一次仅转换 64bit
        fun boolListToLong(boolList: List<Boolean>): ULong {
            var value: ULong = 0u

            if (boolList.count() <= 64) {
                for (index in 0 until boolList.count()) {
                    val bitValue = boolList[index]
                    if (bitValue) {
                        value = value or ((1 shl index).toULong())
                    }
                }
            }

            return value
        }

        @JvmStatic
        fun indexToHexString(index: Int): String {
            var hexString = ""
            var indexTmp = index

            //一次最多处理 64bit
            while (indexTmp / 32 > 0) {
                hexString = "00000000$hexString"
                indexTmp -= 32
            }

            if (indexTmp >= 0) {
                val valueTmp = (1u shl indexTmp)
                val hexStringTmp = valueTmp.toString(16)
                hexString = hexStringTmp + hexString
            }

            return hexString
        }

        @JvmStatic
        fun indexToBoolList(index: Int): List<Boolean> {
            return hexStringToBoolList(indexToHexString(index)) ?: listOf(false)
        }

       
        @JvmStatic
        fun indexListToHexString(indexList: List<Int>): String {
            var hexString = ""

            val indexListSorted = indexList.sorted().toMutableList()

            val threshold = 32
            var thresholdIndex = 1
            val toHandleIndexList = mutableListOf<Int>()

            //[1,12,33,45,66,127,128]

            while (indexListSorted.count() > 0) {
                for (i in 0 until indexListSorted.count()) {
                    if (indexListSorted[i] < threshold * thresholdIndex) {
                        toHandleIndexList.add(indexListSorted[i])
                    }
                }

                if (toHandleIndexList.count() > 0) {
                    var value: ULong = 0u
                    toHandleIndexList.forEach { toHandleIndex ->
                        val shiftLeftBitCount = toHandleIndex % threshold
                        value = value or ((1u shl shiftLeftBitCount).toULong())
                    }
                    val boolList = longToBoolList(value)
                    var hexStringTmp = boolListToHexString(boolList)

                    //添加 hexStringTmp 高位的 "0"
                    while (hexStringTmp.count() < 8) {
                        hexStringTmp = "0$hexStringTmp"
                    }

                    hexString = hexStringTmp + hexString

                    indexListSorted.removeAll(toHandleIndexList)
                    toHandleIndexList.clear()
                } else {
                    hexString = "00000000$hexString"
                }

                thresholdIndex++
            }

            //去除高位无效的 0
            if (hexString.count() > 1) {
                hexString = hexString.replaceFirst(Regex("^0*"), "")
            }

            return hexString
        }

       
        @JvmStatic
        fun indexListToBoolList(indexList: List<Int>): List<Boolean> {
            return hexStringToBoolList(indexListToHexString(indexList)) ?: listOf()
        }
    }
}