package com.sentray.kmmprotocolmodule.utilityToolKit

import com.sentray.kmmprotocolmodule.utilityToolKit.loggerKit.KMMLogger
import kotlin.jvm.JvmStatic
import kotlin.time.DurationUnit
import kotlin.time.ExperimentalTime
import kotlin.time.measureTime

class MeasureTimeKit {
    companion object {
        @ExperimentalTime
        @JvmStatic
        fun measure(runnable: () -> Unit, tag: String) {
            val time = measureTime {
                runnable.invoke()
            }
            KMMLogger.d("$tag 运行耗时 : ${time.toDouble(DurationUnit.MILLISECONDS)}ms")
        }
    }
}