/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.couchinatorw;

import io.github.cdimascio.couchinatorw.CouchinatorException;
import io.github.cdimascio.couchinatorw.CouchinatorOp;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Couchinator {
    private String url;
    private String resourcePath;
    private String npxPath;

    public Couchinator(String npxPath, String url, String resourcePath) {
        this.npxPath = npxPath;
        this.url = url;
        this.resourcePath = resourcePath;
    }

    public Couchinator(String url, String resourcePath) {
        this.url = url;
        this.resourcePath = resourcePath;
        this.npxPath = "npx";
    }

    public void create() throws CouchinatorException {
        this.run(CouchinatorOp.CREATE);
    }

    public void reCreate() throws CouchinatorException {
        this.run(CouchinatorOp.RECREATE);
    }

    public void destroy() throws CouchinatorException {
        this.run(CouchinatorOp.DESTROY);
    }

    private Integer run(final CouchinatorOp op) throws CouchinatorException {
        ProcessBuilder p = new ProcessBuilder(new String[0]);
        ArrayList<String> command = new ArrayList<String>(){
            {
                this.add(Couchinator.this.npxPath);
                this.add("couchinator");
                this.add(op.getOp());
                this.add("--url");
                this.add(Couchinator.this.url);
                this.add("--path");
                this.add(Couchinator.this.resourcePath);
            }
        };
        try {
            Process process = p.command((List<String>)command).start();
            process.waitFor();
            String output = this.convertStreamToString(process.getInputStream());
            String error = this.convertStreamToString(process.getErrorStream());
            System.out.println(output);
            System.out.println(error);
            int exitCode = process.exitValue();
            if (exitCode == 0) {
                return 0;
            }
            throw new CouchinatorException(error);
        }
        catch (IOException | InterruptedException e) {
            throw new CouchinatorException(e);
        }
    }

    private String convertStreamToString(InputStream ins) {
        Scanner s = new Scanner(ins).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

