/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.AppSearchClient;
import co.elasticsearch.enterprisesearch.client.ElasticClientException;
import co.elasticsearch.enterprisesearch.client.ElasticServerException;
import co.elasticsearch.enterprisesearch.client.model.AppSearchErrorResponseException;
import co.elasticsearch.enterprisesearch.client.model.request.Page;
import co.elasticsearch.enterprisesearch.client.model.response.ErrorResponse;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.okhttp.FailsafeCall;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T marshalResponse(OkHttpClient client, Request request, ObjectMapper mapper, Class<T> responseType) {
        log.debug("Making HttpRequest {} {}", (Object)request.method(), (Object)request.url());
        FailsafeCall failsafeCall = FailsafeCall.with((Policy)RetryPolicy.ofDefaults(), (Policy[])new RetryPolicy[0]).compose(client.newCall(request));
        try (Response response = failsafeCall.execute();){
            if (response.body() == null) {
                if (responseType != null) throw new ElasticServerException("Server Response is empty, Expecting " + responseType);
                T t = null;
                return t;
            }
            T t = ClientUtils.marshal(mapper, response, responseType);
            return t;
        }
        catch (IOException e) {
            log.error("Exception during request", (Throwable)e);
            throw new ElasticServerException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T marshalResponse(OkHttpClient client, Request request, ObjectMapper mapper, JavaType responseType) {
        log.debug("Making HttpRequest {} {}", (Object)request.method(), (Object)request.url());
        FailsafeCall failsafeCall = FailsafeCall.with((Policy)RetryPolicy.ofDefaults(), (Policy[])new RetryPolicy[0]).compose(client.newCall(request));
        try (Response response = failsafeCall.execute();){
            if (response.body() == null) {
                if (responseType != null) throw new ElasticServerException("Server Response is empty, Expecting " + responseType);
                T t = null;
                return t;
            }
            T t = ClientUtils.marshal(mapper, response, responseType);
            return t;
        }
        catch (IOException e) {
            log.error("Exception during request", (Throwable)e);
            throw new ElasticServerException(e);
        }
    }

    private static <T> T marshal(ObjectMapper mapper, Response response, JavaType responseType) throws IOException {
        String responseBody = response.body().string();
        try {
            return (T)mapper.readValue(responseBody, responseType);
        }
        catch (MismatchedInputException oops) {
            ErrorResponse err = ClientUtils.attemptErrorResponseMarshal(mapper, responseBody, oops);
            throw new AppSearchErrorResponseException(err, response.code());
        }
        catch (IOException e) {
            log.error("Exception parsing response: {}", (Object)responseBody);
            throw new ElasticServerException(e);
        }
    }

    private static ErrorResponse attemptErrorResponseMarshal(ObjectMapper mapper, String responseBody, MismatchedInputException cause) throws ElasticClientException {
        try {
            return (ErrorResponse)mapper.readValue(responseBody, ErrorResponse.class);
        }
        catch (Exception e) {
            log.trace("Exception trying to marshal an ErrorResponse, probably caused by the original marshalling being incorrect", (Throwable)e);
            throw new ElasticClientException("Unable to parse response", cause);
        }
    }

    private static <T> T marshal(ObjectMapper mapper, Response response, Class<T> responseType) throws IOException {
        String responseBody = response.body().string();
        try {
            return (T)mapper.readValue(responseBody, responseType);
        }
        catch (MismatchedInputException oops) {
            ErrorResponse err = ClientUtils.attemptErrorResponseMarshal(mapper, responseBody, oops);
            throw new AppSearchErrorResponseException(err, response.code());
        }
        catch (IOException e) {
            log.error("Exception parsing response: {}", (Object)responseBody);
            throw new ElasticServerException(e);
        }
    }

    public static void addPagination(HttpUrl.Builder urlBuilder, Page page) {
        if (page != null) {
            if (page.getCurrent() != null) {
                urlBuilder.addQueryParameter("page[current]", String.valueOf(page.getCurrent()));
            }
            if (page.getSize() != null) {
                urlBuilder.addQueryParameter("page[size]", String.valueOf(page.getSize()));
            }
        }
    }

    public static RequestBody marshalPayload(ObjectMapper mapper, Object payload) {
        try {
            return RequestBody.create((byte[])mapper.writeValueAsBytes(payload), (MediaType)AppSearchClient.APP_JSON);
        }
        catch (IOException e) {
            throw new ElasticClientException(e);
        }
    }

    private ClientUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

