/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client;

import co.elasticsearch.enterprisesearch.client.ClientAuthentication;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

class EnterpriseSearchAuthInterceptor
implements Interceptor {
    private final ClientAuthentication auth;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Request.Builder intercepted = chain.request().newBuilder();
        if (this.auth.isTokenAuthentication()) {
            intercepted.header("Authorization", "Bearer " + this.auth.getToken());
        } else {
            intercepted.header("Authorization", Credentials.basic((String)this.auth.getUsername(), (String)this.auth.getPassword(), (Charset)StandardCharsets.UTF_8));
        }
        return chain.proceed(intercepted.build());
    }

    EnterpriseSearchAuthInterceptor(ClientAuthentication auth) {
        this.auth = auth;
    }

    public static EnterpriseSearchAuthInterceptorBuilder builder() {
        return new EnterpriseSearchAuthInterceptorBuilder();
    }

    public static class EnterpriseSearchAuthInterceptorBuilder {
        private ClientAuthentication auth;

        EnterpriseSearchAuthInterceptorBuilder() {
        }

        public EnterpriseSearchAuthInterceptorBuilder auth(ClientAuthentication auth) {
            this.auth = auth;
            return this;
        }

        public EnterpriseSearchAuthInterceptor build() {
            return new EnterpriseSearchAuthInterceptor(this.auth);
        }

        public String toString() {
            return "EnterpriseSearchAuthInterceptor.EnterpriseSearchAuthInterceptorBuilder(auth=" + this.auth + ")";
        }
    }
}

