/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.engines;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class CreateEngine {
    private String name;
    private String type;
    private String language;
    @JsonProperty(value="index_create_settings_override")
    private Map<String, Object> indexCreateSettingsOverride = new LinkedHashMap<String, Object>();

    public CreateEngine setIndexSettingOverride(String key, String value) {
        this.indexCreateSettingsOverride.put(key, value);
        return this;
    }

    public CreateEngine setIndexSettingOverride(String key, Integer value) {
        this.indexCreateSettingsOverride.put(key, value);
        return this;
    }

    public CreateEngine setIndexSettingOverride(String key, Boolean value) {
        this.indexCreateSettingsOverride.put(key, value);
        return this;
    }

    @JsonIgnore
    public Object getIndexSettingOverride(String key) {
        return this.indexCreateSettingsOverride.get(key);
    }

    @JsonIgnore
    public Set<String> getIndexSettingOverrideNames() {
        return this.indexCreateSettingsOverride.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateEngine)) {
            return false;
        }
        CreateEngine that = (CreateEngine)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.language, that.language) && Objects.equals(this.indexCreateSettingsOverride, that.indexCreateSettingsOverride);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.language, this.indexCreateSettingsOverride);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getLanguage() {
        return this.language;
    }

    public CreateEngine setName(String name) {
        this.name = name;
        return this;
    }

    public CreateEngine setType(String type) {
        this.type = type;
        return this;
    }

    public CreateEngine setLanguage(String language) {
        this.language = language;
        return this;
    }

    public String toString() {
        return "CreateEngine(name=" + this.getName() + ", type=" + this.getType() + ", language=" + this.getLanguage() + ", indexCreateSettingsOverride=" + this.getIndexCreateSettingsOverride() + ")";
    }

    Map<String, Object> getIndexCreateSettingsOverride() {
        return this.indexCreateSettingsOverride;
    }

    @JsonProperty(value="index_create_settings_override")
    CreateEngine setIndexCreateSettingsOverride(Map<String, Object> indexCreateSettingsOverride) {
        this.indexCreateSettingsOverride = indexCreateSettingsOverride;
        return this;
    }
}

