/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search;

import co.elasticsearch.enterprisesearch.client.model.GeoLocation;
import co.elasticsearch.enterprisesearch.client.model.Sort;
import co.elasticsearch.enterprisesearch.client.model.SortOrder;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GeoLocationSort
implements SortOrder {
    private final GeoLocation center;
    private Mode mode;
    private Sort.Order order;

    public GeoLocationSort(GeoLocation geoLocation) {
        this.center = geoLocation;
    }

    @Override
    public Sort.Order getOrder() {
        return this.order;
    }

    public GeoLocation getCenter() {
        return this.center;
    }

    public Mode getMode() {
        return this.mode;
    }

    public GeoLocationSort setMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public GeoLocationSort setOrder(Sort.Order order) {
        this.order = order;
        return this;
    }

    public static enum Mode {
        MIN("min"),
        MAX("max"),
        MEDIAN("median"),
        AVERAGE("avg");

        @JsonValue
        private final String value;

        @JsonCreator
        public static Mode fromValue(String value) {
            return Arrays.stream(Mode.values()).filter(m -> m.value.equals(value)).findFirst().orElseThrow();
        }

        public String getValue() {
            return this.value;
        }

        private Mode(String value) {
            this.value = value;
        }
    }
}

