/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SearchField {
    @JsonIgnore
    private String name;
    @Min(value=1L)
    @Max(value=10L)
    private @Min(value=1L) @Max(value=10L) BigDecimal weight;

    public SearchField() {
    }

    public SearchField(String fieldName) {
        this.name = fieldName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchField)) {
            return false;
        }
        SearchField that = (SearchField)o;
        return this.name.equals(that.name) && Objects.equals(this.weight, that.weight);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.weight);
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getWeight() {
        return this.weight;
    }

    @JsonIgnore
    public SearchField setName(String name) {
        this.name = name;
        return this;
    }

    public SearchField setWeight(BigDecimal weight) {
        this.weight = weight;
        return this;
    }
}

