/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.facet;

import co.elasticsearch.enterprisesearch.client.model.Sort;
import co.elasticsearch.enterprisesearch.client.model.request.search.facet.Facet;
import co.elasticsearch.enterprisesearch.client.model.request.search.facet.FacetSortField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.validation.constraints.Min;
import java.util.Map;

@JsonPropertyOrder(value={"type", "name", "sort", "size"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize
public class ValueFacet
implements Facet {
    private String fieldName;
    private final String type = "value";
    private String name;
    @Min(value=1L)
    private @Min(value=1L) Integer size;
    @JsonIgnore
    private FacetSortField sortField = FacetSortField.COUNT;
    @JsonIgnore
    private Sort.Order sortOrder = Sort.Order.DESCENDING;

    public ValueFacet() {
    }

    public ValueFacet(String fieldName) {
        this.fieldName = fieldName;
    }

    @JsonProperty(value="sort")
    Map<FacetSortField, Sort.Order> getSort() {
        return Map.of(this.sortField, this.sortOrder);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return this.size;
    }

    public FacetSortField getSortField() {
        return this.sortField;
    }

    public Sort.Order getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public ValueFacet setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public ValueFacet setName(String name) {
        this.name = name;
        return this;
    }

    public ValueFacet setSize(Integer size) {
        this.size = size;
        return this;
    }

    @JsonIgnore
    public ValueFacet setSortField(FacetSortField sortField) {
        this.sortField = sortField;
        return this;
    }

    @JsonIgnore
    public ValueFacet setSortOrder(Sort.Order sortOrder) {
        this.sortOrder = sortOrder;
        return this;
    }
}

