/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BooleanFilter
implements Filter {
    private List<Filter> all = new ArrayList<Filter>();
    private List<Filter> any = new ArrayList<Filter>();
    private List<Filter> none = new ArrayList<Filter>();

    public BooleanFilter allOf(Filter ... filters) {
        this.all.addAll(Arrays.asList(filters));
        return this;
    }

    public BooleanFilter anyOf(Filter ... filters) {
        this.any.addAll(Arrays.asList(filters));
        return this;
    }

    public BooleanFilter noneOf(Filter ... filters) {
        this.none.addAll(Arrays.asList(filters));
        return this;
    }

    @JsonValue
    Map<String, List<Filter>> values() {
        LinkedHashMap<String, List<Filter>> values = new LinkedHashMap<String, List<Filter>>();
        if (!this.all.isEmpty()) {
            values.put("all", this.all);
        }
        if (!this.any.isEmpty()) {
            values.put("any", this.any);
        }
        if (!this.none.isEmpty()) {
            values.put("none", this.none);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BooleanFilter)) {
            return false;
        }
        BooleanFilter that = (BooleanFilter)o;
        return Objects.equals(this.all, that.all) && Objects.equals(this.any, that.any) && Objects.equals(this.none, that.none);
    }

    public int hashCode() {
        return Objects.hash(this.all, this.any, this.none);
    }

    public List<Filter> getAll() {
        return this.all;
    }

    public List<Filter> getAny() {
        return this.any;
    }

    public List<Filter> getNone() {
        return this.none;
    }

    public BooleanFilter setAll(List<Filter> all) {
        this.all = all;
        return this;
    }

    public BooleanFilter setAny(List<Filter> any) {
        this.any = any;
        return this;
    }

    public BooleanFilter setNone(List<Filter> none) {
        this.none = none;
        return this;
    }

    public String toString() {
        return "BooleanFilter(all=" + this.getAll() + ", any=" + this.getAny() + ", none=" + this.getNone() + ")";
    }
}

