/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DateValueFilter
implements Filter {
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss[.SS]XXX";
    public static final DateTimeFormatter RFC_3339 = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss[.SS]XXX");
    @JsonIgnore
    private final String name;
    private List<OffsetDateTime> values = new ArrayList<OffsetDateTime>();

    public DateValueFilter(String name, OffsetDateTime ... values) {
        this(name, Arrays.asList(values));
    }

    public DateValueFilter(String name, List<OffsetDateTime> values) {
        this(name);
        this.values.addAll(values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateValueFilter)) {
            return false;
        }
        DateValueFilter that = (DateValueFilter)o;
        return this.name.equals(that.name) && this.values.equals(that.values);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.values);
    }

    public String getName() {
        return this.name;
    }

    public List<OffsetDateTime> getValues() {
        return this.values;
    }

    public DateValueFilter setValues(List<OffsetDateTime> values) {
        this.values = values;
        return this;
    }

    public DateValueFilter(String name) {
        this.name = name;
    }

    public String toString() {
        return "DateValueFilter(name=" + this.getName() + ", values=" + this.getValues() + ")";
    }
}

