/*
 * Decompiled with CFR 0.152.
 */
package co.elasticsearch.enterprisesearch.client.model.request.search.filter;

import co.elasticsearch.enterprisesearch.client.model.GeoLocation;
import co.elasticsearch.enterprisesearch.client.model.GeolocationRange;
import co.elasticsearch.enterprisesearch.client.model.request.search.filter.Filter;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GeolocationFilter
implements Filter {
    private final String name;
    private GeoLocation center;
    private BigDecimal distance;
    private GeoLocation.Unit unit;
    private BigDecimal from;
    private BigDecimal to;

    public GeolocationFilter setRange(GeolocationRange range) {
        this.to = range == null ? null : range.getTo();
        this.from = range == null ? null : range.getFrom();
        this.unit = range == null ? null : range.getUnit();
        this.center = range == null ? null : range.getCenter();
        this.distance = range == null ? null : range.getDistance();
        return this;
    }

    public GeolocationRange getRange() {
        return new GeolocationRange().setCenter(this.center).setFrom(this.from).setTo(this.to).setUnit(this.unit).setDistance(this.distance);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeolocationFilter)) {
            return false;
        }
        GeolocationFilter that = (GeolocationFilter)o;
        return this.name.equals(that.name) && this.center.equals(that.center) && Objects.equals(this.distance, that.distance) && this.unit == that.unit && Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.center, this.distance, this.unit, this.from, this.to});
    }

    public String getName() {
        return this.name;
    }

    public GeoLocation getCenter() {
        return this.center;
    }

    public BigDecimal getDistance() {
        return this.distance;
    }

    public GeoLocation.Unit getUnit() {
        return this.unit;
    }

    public BigDecimal getFrom() {
        return this.from;
    }

    public BigDecimal getTo() {
        return this.to;
    }

    public GeolocationFilter setCenter(GeoLocation center) {
        this.center = center;
        return this;
    }

    public GeolocationFilter setDistance(BigDecimal distance) {
        this.distance = distance;
        return this;
    }

    public GeolocationFilter setUnit(GeoLocation.Unit unit) {
        this.unit = unit;
        return this;
    }

    public GeolocationFilter setFrom(BigDecimal from) {
        this.from = from;
        return this;
    }

    public GeolocationFilter setTo(BigDecimal to) {
        this.to = to;
        return this;
    }

    public GeolocationFilter(String name) {
        this.name = name;
    }

    public String toString() {
        return "GeolocationFilter(name=" + this.getName() + ", center=" + this.getCenter() + ", distance=" + this.getDistance() + ", unit=" + this.getUnit() + ", from=" + this.getFrom() + ", to=" + this.getTo() + ")";
    }
}

